/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.cassandra.CassandraDataAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.cassandra.core.ReactiveCassandraTemplate;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cql.core.session.DefaultBridgedReactiveSession;
import org.springframework.data.cql.core.session.DefaultReactiveSessionFactory;
import org.springframework.data.cql.core.session.ReactiveSession;
import org.springframework.data.cql.core.session.ReactiveSessionFactory;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

@Configuration
@ConditionalOnClass(value={Cluster.class, ReactiveCassandraTemplate.class, Flux.class})
@ConditionalOnBean(value={Session.class})
@AutoConfigureAfter(value={CassandraDataAutoConfiguration.class})
public class CassandraReactiveDataAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ReactiveSession.class})
    public ReactiveSession reactiveCassandraSession(Session session) {
        return new DefaultBridgedReactiveSession(session, Schedulers.elastic());
    }

    @Bean
    public ReactiveSessionFactory reactiveCassandraSessionFactory(ReactiveSession reactiveCassandraSession) {
        return new DefaultReactiveSessionFactory(reactiveCassandraSession);
    }

    @Bean
    @ConditionalOnMissingBean
    public ReactiveCassandraTemplate reactiveCassandraTemplate(ReactiveSession reactiveCassandraSession, CassandraConverter converter) {
        return new ReactiveCassandraTemplate(reactiveCassandraSession, converter);
    }
}

