/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.elasticsearch;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.cluster.Health;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class ElasticsearchJestHealthIndicator
extends AbstractHealthIndicator {
    private final JestClient jestClient;
    private final JsonParser jsonParser = new JsonParser();

    public ElasticsearchJestHealthIndicator(JestClient jestClient) {
        super("Elasticsearch health check failed");
        this.jestClient = jestClient;
    }

    @Override
    protected void doHealthCheck(Health.Builder builder) throws Exception {
        JestResult healthResult = this.jestClient.execute((Action)new Health.Builder().build());
        if (healthResult.getResponseCode() != 200 || !healthResult.isSucceeded()) {
            builder.down();
        } else {
            JsonElement root = this.jsonParser.parse(healthResult.getJsonString());
            JsonElement status = root.getAsJsonObject().get("status");
            if (status.getAsString().equals(Health.Status.RED.getKey())) {
                builder.outOfService();
            } else {
                builder.up();
            }
        }
    }
}

