/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.reactive;

import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextType;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerFactoryCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.reactive.DefaultReactiveWebServerFactoryCustomizer;
import org.springframework.boot.web.reactive.server.ConfigurableReactiveWebServerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.web.reactive.config.EnableWebFlux;
import org.springframework.web.server.adapter.WebHttpHandlerBuilder;

@EnableWebFlux
@ManagementContextConfiguration(value=ManagementContextType.CHILD)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
public class ReactiveManagementChildContextConfiguration {
    @Bean
    public ReactiveManagementServerFactoryCustomizer reactiveManagementServerFactoryCustomizer(ListableBeanFactory beanFactory) {
        return new ReactiveManagementServerFactoryCustomizer(beanFactory);
    }

    @Bean
    public HttpHandler httpHandler(ApplicationContext applicationContext) {
        return WebHttpHandlerBuilder.applicationContext((ApplicationContext)applicationContext).build();
    }

    class ReactiveManagementServerFactoryCustomizer
    extends ManagementServerFactoryCustomizer<ConfigurableReactiveWebServerFactory> {
        ReactiveManagementServerFactoryCustomizer(ListableBeanFactory beanFactory) {
            super(beanFactory, DefaultReactiveWebServerFactoryCustomizer.class);
        }
    }
}

