/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.security.servlet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.web.PathMappedEndpoints;
import org.springframework.boot.security.servlet.ApplicationContextRequestMatcher;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class EndpointRequest {
    private EndpointRequest() {
    }

    public static EndpointRequestMatcher toAnyEndpoint() {
        return new EndpointRequestMatcher();
    }

    public static EndpointRequestMatcher to(Class<?> ... endpoints) {
        return new EndpointRequestMatcher(endpoints);
    }

    public static EndpointRequestMatcher to(String ... endpoints) {
        return new EndpointRequestMatcher(endpoints);
    }

    public static final class EndpointRequestMatcher
    extends ApplicationContextRequestMatcher<PathMappedEndpoints> {
        private final List<Object> includes;
        private final List<Object> excludes;
        private RequestMatcher delegate;

        private EndpointRequestMatcher() {
            this(Collections.emptyList(), Collections.emptyList());
        }

        private EndpointRequestMatcher(Class<?>[] endpoints) {
            this(Arrays.asList((Object[])endpoints), Collections.emptyList());
        }

        private EndpointRequestMatcher(String[] endpoints) {
            this(Arrays.asList((Object[])endpoints), Collections.emptyList());
        }

        private EndpointRequestMatcher(List<Object> includes, List<Object> excludes) {
            super(PathMappedEndpoints.class);
            this.includes = includes;
            this.excludes = excludes;
        }

        EndpointRequestMatcher excluding(Class<?> ... endpoints) {
            ArrayList<Object> excludes = new ArrayList<Object>(this.excludes);
            excludes.addAll(Arrays.asList((Object[])endpoints));
            return new EndpointRequestMatcher(this.includes, excludes);
        }

        EndpointRequestMatcher excluding(String ... endpoints) {
            ArrayList<Object> excludes = new ArrayList<Object>(this.excludes);
            excludes.addAll(Arrays.asList((Object[])endpoints));
            return new EndpointRequestMatcher(this.includes, excludes);
        }

        protected void initialized(PathMappedEndpoints pathMappedEndpoints) {
            LinkedHashSet<String> paths = new LinkedHashSet<String>();
            if (this.includes.isEmpty()) {
                paths.addAll(pathMappedEndpoints.getAllPaths());
            }
            this.streamPaths(this.includes, pathMappedEndpoints).forEach(paths::add);
            this.streamPaths(this.excludes, pathMappedEndpoints).forEach(paths::remove);
            this.delegate = new OrRequestMatcher(this.getDelegateMatchers(paths));
        }

        private Stream<String> streamPaths(List<Object> source, PathMappedEndpoints pathMappedEndpoints) {
            return source.stream().filter(Objects::nonNull).map(this::getEndpointId).map(arg_0 -> ((PathMappedEndpoints)pathMappedEndpoints).getPath(arg_0));
        }

        private String getEndpointId(Object source) {
            if (source instanceof String) {
                return (String)source;
            }
            if (source instanceof Class) {
                return this.getEndpointId((Class)source);
            }
            throw new IllegalStateException("Unsupported source " + source);
        }

        private String getEndpointId(Class<?> source) {
            Endpoint annotation = (Endpoint)AnnotationUtils.findAnnotation(source, Endpoint.class);
            Assert.state((annotation != null ? 1 : 0) != 0, () -> "Class " + source + " is not annotated with @Endpoint");
            return annotation.id();
        }

        private List<RequestMatcher> getDelegateMatchers(Set<String> paths) {
            return paths.stream().map(path -> new AntPathRequestMatcher(path + "/**")).collect(Collectors.toList());
        }

        protected boolean matches(HttpServletRequest request, PathMappedEndpoints context) {
            return this.delegate.matches(request);
        }
    }
}

