/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.jdbc;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import java.util.Collection;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.metrics.jdbc.JdbcMetricsProperties;
import org.springframework.boot.actuate.metrics.jdbc.DataSourcePoolMetrics;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnBean(value={DataSource.class, DataSourcePoolMetadataProvider.class})
@ConditionalOnProperty(value={"management.metrics.jdbc.instrument"}, matchIfMissing=true)
@EnableConfigurationProperties(value={JdbcMetricsProperties.class})
public class DataSourcePoolMetricsConfiguration {
    private static final String DATASOURCE_SUFFIX = "dataSource";
    private final MeterRegistry registry;
    private final Collection<DataSourcePoolMetadataProvider> metadataProviders;
    private final String metricName;

    public DataSourcePoolMetricsConfiguration(MeterRegistry registry, Collection<DataSourcePoolMetadataProvider> metadataProviders, JdbcMetricsProperties jdbcMetricsProperties) {
        this.registry = registry;
        this.metadataProviders = metadataProviders;
        this.metricName = jdbcMetricsProperties.getMetricName();
    }

    @Autowired
    public void bindDataSourcesToRegistry(Map<String, DataSource> dataSources) {
        dataSources.forEach(this::bindDataSourceToRegistry);
    }

    private void bindDataSourceToRegistry(String beanName, DataSource dataSource) {
        String dataSourceName = this.getDataSourceName(beanName);
        new DataSourcePoolMetrics(dataSource, this.metadataProviders, this.metricName, (Iterable)Tags.of((String)"name", (String)dataSourceName)).bindTo(this.registry);
    }

    private String getDataSourceName(String beanName) {
        if (beanName.length() > DATASOURCE_SUFFIX.length() && StringUtils.endsWithIgnoreCase((String)beanName, (String)DATASOURCE_SUFFIX)) {
            return beanName.substring(0, beanName.length() - DATASOURCE_SUFFIX.length());
        }
        return beanName;
    }
}

