/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.export.jmx;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.jmx.JmxConfig;
import io.micrometer.jmx.JmxMeterRegistry;
import org.springframework.boot.actuate.autoconfigure.metrics.export.jmx.JmxProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.export.jmx.JmxPropertiesConfigAdapter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={JmxMeterRegistry.class})
@EnableConfigurationProperties(value={JmxProperties.class})
public class JmxExportConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public JmxConfig jmxConfig(JmxProperties jmxProperties) {
        return new JmxPropertiesConfigAdapter(jmxProperties);
    }

    @Bean
    @ConditionalOnProperty(value={"management.metrics.export.jmx.enabled"}, matchIfMissing=true)
    public JmxMeterRegistry jmxMeterRegistry(JmxConfig config, HierarchicalNameMapper nameMapper, Clock clock) {
        return new JmxMeterRegistry(config, clock, nameMapper);
    }

    @Bean
    @ConditionalOnMissingBean
    public HierarchicalNameMapper hierarchicalNameMapper() {
        return HierarchicalNameMapper.DEFAULT;
    }
}

