/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.amqp;

import com.rabbitmq.client.ConnectionFactory;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import java.util.Map;
import org.springframework.amqp.rabbit.connection.AbstractConnectionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.metrics.amqp.RabbitMetricsProperties;
import org.springframework.boot.actuate.metrics.amqp.RabbitMetrics;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={ConnectionFactory.class, AbstractConnectionFactory.class})
@ConditionalOnBean(value={AbstractConnectionFactory.class})
@ConditionalOnProperty(value={"management.metrics.rabbitmq.instrument"}, matchIfMissing=true)
@EnableConfigurationProperties(value={RabbitMetricsProperties.class})
public class RabbitMetricsConfiguration {
    private static final String CONNECTION_FACTORY_SUFFIX = "connectionFactory";
    private final MeterRegistry registry;
    private final String metricName;

    public RabbitMetricsConfiguration(MeterRegistry registry, RabbitMetricsProperties rabbitMetricsProperties) {
        this.registry = registry;
        this.metricName = rabbitMetricsProperties.getMetricName();
    }

    @Autowired
    public void bindConnectionFactoriesToRegistry(Map<String, AbstractConnectionFactory> connectionFactories) {
        connectionFactories.forEach(this::bindConnectionFactoryToRegistry);
    }

    private void bindConnectionFactoryToRegistry(String beanName, AbstractConnectionFactory connectionFactory) {
        ConnectionFactory rabbitConnectionFactory = connectionFactory.getRabbitConnectionFactory();
        String connectionFactoryName = this.getConnectionFactoryName(beanName);
        new RabbitMetrics(rabbitConnectionFactory, this.metricName, (Iterable)Tags.of((String)"name", (String)connectionFactoryName)).bindTo(this.registry);
    }

    private String getConnectionFactoryName(String beanName) {
        if (beanName.length() > CONNECTION_FACTORY_SUFFIX.length() && StringUtils.endsWithIgnoreCase((String)beanName, (String)CONNECTION_FACTORY_SUFFIX)) {
            return beanName.substring(0, beanName.length() - CONNECTION_FACTORY_SUFFIX.length());
        }
        return beanName;
    }
}

