/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="management.metrics")
public class MetricsProperties {
    private final Web web = new Web();
    private boolean useGlobalRegistry = true;

    public boolean isUseGlobalRegistry() {
        return this.useGlobalRegistry;
    }

    public void setUseGlobalRegistry(boolean useGlobalRegistry) {
        this.useGlobalRegistry = useGlobalRegistry;
    }

    public Web getWeb() {
        return this.web;
    }

    public static class Web {
        private final Client client = new Client();
        private final Server server = new Server();

        public Client getClient() {
            return this.client;
        }

        public Server getServer() {
            return this.server;
        }

        public static class Server {
            private boolean autoTimeRequests = true;
            private boolean recordRequestPercentiles;
            private String requestsMetricName = "http.server.requests";

            public boolean isAutoTimeRequests() {
                return this.autoTimeRequests;
            }

            public void setAutoTimeRequests(boolean autoTimeRequests) {
                this.autoTimeRequests = autoTimeRequests;
            }

            public boolean isRecordRequestPercentiles() {
                return this.recordRequestPercentiles;
            }

            public void setRecordRequestPercentiles(boolean recordRequestPercentiles) {
                this.recordRequestPercentiles = recordRequestPercentiles;
            }

            public String getRequestsMetricName() {
                return this.requestsMetricName;
            }

            public void setRequestsMetricName(String requestsMetricName) {
                this.requestsMetricName = requestsMetricName;
            }
        }

        public static class Client {
            private boolean recordRequestPercentiles;
            private String requestsMetricName = "http.client.requests";
            private int maxUriTags = 100;

            public boolean isRecordRequestPercentiles() {
                return this.recordRequestPercentiles;
            }

            public void setRecordRequestPercentiles(boolean recordRequestPercentiles) {
                this.recordRequestPercentiles = recordRequestPercentiles;
            }

            public String getRequestsMetricName() {
                return this.requestsMetricName;
            }

            public void setRequestsMetricName(String requestsMetricName) {
                this.requestsMetricName = requestsMetricName;
            }

            public int getMaxUriTags() {
                return this.maxUriTags;
            }

            public void setMaxUriTags(int maxUriTags) {
                this.maxUriTags = maxUriTags;
            }
        }
    }
}

