/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.autoconfigure.metrics.MeterRegistryCustomizer;
import org.springframework.boot.util.LambdaSafe;

class MeterRegistryPostProcessor
implements BeanPostProcessor {
    private final Collection<MeterRegistryCustomizer<?>> customizers;
    private final Collection<MeterFilter> filters;
    private final Collection<MeterBinder> binders;
    private final boolean addToGlobalRegistry;

    MeterRegistryPostProcessor(Collection<MeterBinder> binders, Collection<MeterFilter> filters, Collection<MeterRegistryCustomizer<?>> customizers, boolean addToGlobalRegistry) {
        this.binders = binders != null ? binders : Collections.emptyList();
        this.filters = filters != null ? filters : Collections.emptyList();
        this.customizers = customizers != null ? customizers : Collections.emptyList();
        this.addToGlobalRegistry = addToGlobalRegistry;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof MeterRegistry) {
            this.postProcess((MeterRegistry)bean);
        }
        return bean;
    }

    private void postProcess(MeterRegistry registry) {
        if (registry instanceof CompositeMeterRegistry) {
            return;
        }
        this.customize(registry);
        this.addFilters(registry);
        this.addBinders(registry);
        if (this.addToGlobalRegistry && registry != Metrics.globalRegistry) {
            Metrics.addRegistry((MeterRegistry)registry);
        }
    }

    private void customize(MeterRegistry registry) {
        ((LambdaSafe.Callbacks)LambdaSafe.callbacks(MeterRegistryCustomizer.class, this.customizers, (Object)registry, (Object[])new Object[0]).withLogger(MeterRegistryPostProcessor.class)).invoke(customizer -> customizer.customize(registry));
    }

    private void addFilters(MeterRegistry registry) {
        this.filters.forEach(arg_0 -> ((MeterRegistry.Config)registry.config()).meterFilter(arg_0));
    }

    private void addBinders(MeterRegistry registry) {
        this.binders.forEach(binder -> binder.bindTo(registry));
    }
}

