/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.util;

import java.io.File;
import java.io.IOException;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.util.Assert;

public final class FileUtils {
    private FileUtils() {
    }

    public static void setUpOutputFile(File file, boolean restarted, boolean append, boolean overwriteOutputFile) {
        Assert.notNull((Object)file);
        try {
            if (!restarted) {
                if (!append) {
                    if (file.exists()) {
                        if (!overwriteOutputFile) {
                            throw new ItemStreamException("File already exists: [" + file.getAbsolutePath() + "]");
                        }
                        if (!file.delete()) {
                            throw new IOException("Could not delete file: " + file);
                        }
                    }
                    if (file.getParent() != null) {
                        new File(file.getParent()).mkdirs();
                    }
                    if (!FileUtils.createNewFile(file)) {
                        throw new ItemStreamException("Output file was not created: [" + file.getAbsolutePath() + "]");
                    }
                } else if (!file.exists()) {
                    if (file.getParent() != null) {
                        new File(file.getParent()).mkdirs();
                    }
                    if (!FileUtils.createNewFile(file)) {
                        throw new ItemStreamException("Output file was not created: [" + file.getAbsolutePath() + "]");
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new ItemStreamException("Unable to create file: [" + file.getAbsolutePath() + "]", ioe);
        }
        if (!file.canWrite()) {
            throw new ItemStreamException("File is not writable: [" + file.getAbsolutePath() + "]");
        }
    }

    @Deprecated
    public static void setUpOutputFile(File file, boolean restarted, boolean overwriteOutputFile) {
        FileUtils.setUpOutputFile(file, restarted, false, overwriteOutputFile);
    }

    public static boolean createNewFile(File file) throws IOException {
        if (file.exists()) {
            return false;
        }
        try {
            return file.createNewFile() && file.exists();
        }
        catch (IOException e) {
            if (file.exists()) {
                return true;
            }
            throw e;
        }
    }
}

