/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.orm;

import org.hibernate.query.NativeQuery;
import org.springframework.batch.item.database.orm.AbstractHibernateQueryProvider;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class HibernateNativeQueryProvider<E>
extends AbstractHibernateQueryProvider {
    private String sqlQuery;
    private Class<E> entityClass;

    public NativeQuery createQuery() {
        if (this.isStatelessSession()) {
            return this.getStatelessSession().createNativeQuery(this.sqlQuery).addEntity(this.entityClass);
        }
        return this.getStatefulSession().createNativeQuery(this.sqlQuery).addEntity(this.entityClass);
    }

    public void setSqlQuery(String sqlQuery) {
        this.sqlQuery = sqlQuery;
    }

    public void setEntityClass(Class<E> entityClazz) {
        this.entityClass = entityClazz;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.isTrue((boolean)StringUtils.hasText((String)this.sqlQuery), (String)"Native SQL query cannot be empty");
        Assert.notNull(this.entityClass, (String)"Entity class cannot be NULL");
    }
}

