/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.data;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.neo4j.template.Neo4jOperations;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class Neo4jItemWriter<T>
implements ItemWriter<T>,
InitializingBean {
    protected static final Log logger = LogFactory.getLog(Neo4jItemWriter.class);
    private boolean delete = false;
    private Neo4jOperations template;
    private SessionFactory sessionFactory;
    private boolean useSession = false;

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    @Deprecated
    public void setTemplate(Neo4jOperations template) {
        this.template = template;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.template != null || this.sessionFactory != null ? 1 : 0) != 0, (String)"A Neo4JOperations implementation or a SessionFactory is required");
        this.useSession = this.sessionFactory != null;
    }

    @Override
    public void write(List<? extends T> items) throws Exception {
        if (!CollectionUtils.isEmpty(items)) {
            this.doWrite(items);
        }
    }

    protected void doWrite(List<? extends T> items) {
        if (this.delete) {
            this.delete(items);
        } else {
            this.save(items);
        }
    }

    private void delete(List<? extends T> items) {
        if (this.useSession) {
            Session session = this.sessionFactory.openSession();
            items.forEach(arg_0 -> ((Session)session).delete(arg_0));
        } else {
            for (Object object : items) {
                this.template.delete(object);
            }
        }
    }

    private void save(List<? extends T> items) {
        if (this.useSession) {
            Session session = this.sessionFactory.openSession();
            items.forEach(arg_0 -> ((Session)session).save(arg_0));
        } else {
            for (Object object : items) {
                this.template.save(object);
            }
        }
    }
}

