/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.objc;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.robovm.objc.ObjCClassNotFoundException;
import org.robovm.objc.ObjCObject;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.Selector;
import org.robovm.objc.annotation.BindSelector;
import org.robovm.objc.annotation.CustomClass;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.TypeEncoding;
import org.robovm.rt.VM;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="objc")
public final class ObjCClass
extends ObjCObject {
    private static final Map<Class<? extends ObjCObject>, ObjCClass> typeToClass;
    private static final Map<String, ObjCClass> nameToClass;
    private static final Map<String, Class<? extends ObjCObject>> allNativeClasses;
    private static final Map<String, Class<? extends ObjCObject>> allCustomClasses;
    static final Map<String, Class<? extends ObjCObject>> allObjCProxyClasses;
    private static final int ACC_SYNTHETIC = 4096;
    private static final String CUSTOM_CLASS_NAME_PREFIX = "j_";
    private final Class<? extends ObjCObject> type;
    private final String name;
    private final boolean custom;

    static boolean isObjCProxy(Class<?> cls) {
        return (cls.getModifiers() & 0x1000) > 0 && cls.getName().endsWith("$ObjCProxy");
    }

    private ObjCClass(long handle, Class<? extends ObjCObject> type, String name, boolean custom) {
        super(handle, false);
        this.type = type;
        this.name = name;
        this.custom = custom;
    }

    public Class<? extends ObjCObject> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public String toString() {
        return this.type.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjCClass getByName(String objcClassName) {
        Object object = objcBridgeLock;
        synchronized (object) {
            ObjCClass c = nameToClass.get(objcClassName);
            if (c == null && (c = ObjCClass.getByNameNotLoaded(objcClassName)) == null) {
                throw new ObjCClassNotFoundException("Could not find Java class corresponding to Objective-C class: " + objcClassName);
            }
            return c;
        }
    }

    private static ObjCClass getByNameNotLoaded(String objcClassName) {
        Class<? extends ObjCObject> cls = allNativeClasses.get(objcClassName);
        if (cls != null) {
            return ObjCClass.getByType(cls);
        }
        cls = allCustomClasses.get(objcClassName);
        if (cls != null) {
            return ObjCClass.getByType(cls);
        }
        return null;
    }

    public static ObjCClass getFromObject(ObjCObject id) {
        long handle = id.getHandle();
        ObjCClass c = null;
        if (handle != 0L) {
            long classPtr = ObjCRuntime.object_getClass(handle);
            c = (ObjCClass)((Object)ObjCObject.getPeerObject(classPtr));
        }
        if (c != null) {
            return c;
        }
        return ObjCClass.getByType(((Object)((Object)id)).getClass());
    }

    public static ObjCClass getFromObject(long handle) {
        long classPtr = ObjCRuntime.object_getClass(handle);
        return ObjCClass.toObjCClass(classPtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjCClass getByType(Class<? extends ObjCObject> type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        Object object = objcBridgeLock;
        synchronized (object) {
            ObjCClass c = typeToClass.get(type);
            if (c == null) {
                NativeClass nativeClassAnno = type.getAnnotation(NativeClass.class);
                String name = null;
                if (nativeClassAnno != null) {
                    name = nativeClassAnno.value();
                    name = "".equals(name) ? type.getSimpleName() : name;
                } else {
                    name = ObjCClass.getCustomClassName(type);
                    c = ObjCClass.register(type, name);
                }
                if (c == null) {
                    long classPtr = ObjCRuntime.objc_getClass(VM.getStringUTFChars((String)name));
                    if (classPtr == 0L) {
                        throw new ObjCClassNotFoundException(name);
                    }
                    c = new ObjCClass(classPtr, type, name, false);
                }
                typeToClass.put(type, c);
                nameToClass.put(name, c);
            }
            return c;
        }
    }

    public static ObjCClass toObjCClass(long handle) {
        long classPtr = handle;
        ObjCClass c = (ObjCClass)((Object)ObjCObject.getPeerObject(classPtr));
        if (c == null) {
            c = ObjCClass.getByNameNotLoaded(VM.newStringUTF((long)ObjCRuntime.class_getName(classPtr)));
        }
        while (c == null && classPtr != 0L) {
            c = (ObjCClass)((Object)ObjCObject.getPeerObject(classPtr = ObjCRuntime.class_getSuperclass(classPtr)));
            if (c != null) continue;
            c = ObjCClass.getByNameNotLoaded(VM.newStringUTF((long)ObjCRuntime.class_getName(classPtr)));
        }
        if (c == null) {
            String name = VM.newStringUTF((long)ObjCRuntime.class_getName(handle));
            throw new ObjCClassNotFoundException("Could not find Java class corresponding to Objective-C class: " + name);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjCClass registerCustomClass(Class<? extends ObjCObject> type) {
        if (type.getAnnotation(NativeClass.class) != null) {
            throw new IllegalArgumentException("@NativeClass annotated class " + type.getName() + " can not be registered as a custom class");
        }
        Object object = objcBridgeLock;
        synchronized (object) {
            ObjCClass c = typeToClass.get(type);
            if (c == null) {
                String name = ObjCClass.getCustomClassName(type);
                c = ObjCClass.register(type, name);
                typeToClass.put(type, c);
                nameToClass.put(name, c);
            }
            return c;
        }
    }

    private static String getCustomClassName(Class<? extends ObjCObject> type) {
        CustomClass customClassAnno = type.getAnnotation(CustomClass.class);
        String name = type.getName();
        name = customClassAnno != null && customClassAnno.value().length() > 0 ? customClassAnno.value() : CUSTOM_CLASS_NAME_PREFIX + name;
        name = name.replace('.', '_');
        return name;
    }

    private static ObjCClass register(Class<? extends ObjCObject> type, String name) {
        ObjCClass superclass = ObjCClass.getByType(type.getSuperclass());
        long handle = ObjCRuntime.objc_allocateClassPair(superclass.getHandle(), VM.getStringUTFChars((String)name), 0L);
        if (handle == 0L) {
            throw new ObjCClassNotFoundException("Failed to create custom Objective-C class for Java class: " + type);
        }
        for (Map.Entry<String, Method> entry : ObjCClass.getCallbacks(type).entrySet()) {
            boolean isClassMethod;
            String selName = entry.getKey();
            Method method = entry.getValue();
            boolean bl = isClassMethod = method.getParameterTypes()[0] == ObjCClass.class;
            if (isClassMethod && method.getDeclaringClass() != type) continue;
            Selector selector = Selector.register(selName);
            String encoding = null;
            TypeEncoding typeEncoding = method.getAnnotation(TypeEncoding.class);
            if (typeEncoding != null) {
                encoding = typeEncoding.value();
            } else {
                long encodingPtr;
                long methodPtr;
                long l = methodPtr = isClassMethod ? ObjCRuntime.class_getClassMethod(superclass.getHandle(), selector.getHandle()) : ObjCRuntime.class_getInstanceMethod(superclass.getHandle(), selector.getHandle());
                if (methodPtr != 0L && (encodingPtr = ObjCRuntime.method_getTypeEncoding(methodPtr)) != 0L) {
                    encoding = VM.newStringUTF((long)encodingPtr);
                }
            }
            long impl = VM.getCallbackMethodImpl((Method)method);
            long ownerHandle = isClassMethod ? ObjCRuntime.object_getClass(handle) : handle;
            if (ObjCRuntime.class_addMethod(ownerHandle, selector.getHandle(), impl, encoding != null ? VM.getStringUTFChars((String)encoding) : 0L)) continue;
            throw new ObjCClassNotFoundException("Failed to add method " + selName + " to custom Objective-C class for Java class: " + type);
        }
        ObjCObject.ObjectOwnershipHelper.registerClass(handle);
        ObjCRuntime.objc_registerClassPair(handle);
        return new ObjCClass(handle, type, name, true);
    }

    private static Map<String, Method> getCallbacks(Class<?> type) {
        HashMap<String, Method> callbacks = new HashMap<String, Method>();
        ObjCClass.findCallbacks(type, callbacks);
        return callbacks;
    }

    private static void findCallbacks(Class<?> type, Map<String, Method> result) {
        for (Method m : type.getDeclaredMethods()) {
            BindSelector bindSelector;
            if (m.getAnnotation(Callback.class) == null || (bindSelector = m.getAnnotation(BindSelector.class)) == null || result.containsKey(bindSelector.value())) continue;
            result.put(bindSelector.value(), m);
        }
    }

    static {
        Class[] classes;
        typeToClass = new HashMap<Class<? extends ObjCObject>, ObjCClass>();
        nameToClass = new HashMap<String, ObjCClass>();
        allNativeClasses = new HashMap<String, Class<? extends ObjCObject>>();
        allCustomClasses = new HashMap<String, Class<? extends ObjCObject>>();
        allObjCProxyClasses = new HashMap<String, Class<? extends ObjCObject>>();
        ObjCRuntime.bind(ObjCClass.class);
        for (Class cls : classes = VM.listClasses(ObjCObject.class, (ClassLoader)ClassLoader.getSystemClassLoader())) {
            String name;
            NativeClass nativeClassAnno = cls.getAnnotation(NativeClass.class);
            if (nativeClassAnno != null) {
                name = nativeClassAnno.value();
                if (name.length() == 0) {
                    name = cls.getSimpleName();
                }
                allNativeClasses.put(name, cls);
            } else {
                CustomClass customClassAnno = cls.getAnnotation(CustomClass.class);
                String name2 = cls.getName();
                if (customClassAnno != null) {
                    String value = customClassAnno.value();
                    if (value.length() > 0) {
                        name2 = value;
                    }
                } else if (name2.indexOf(46) == -1) {
                    name2 = "." + name2;
                }
                allCustomClasses.put(name2, cls);
            }
            if (!ObjCClass.isObjCProxy(cls)) continue;
            name = cls.getName();
            String protocolName = name.substring(0, name.length() - 10);
            allObjCProxyClasses.put(protocolName, cls);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static Class<? extends ObjCObject> toObject(Class<ObjCClass> cls, long handle, long flags) {
            ObjCClass o = ObjCClass.toObjCClass(handle);
            if (o == null) {
                return null;
            }
            return o.getType();
        }

        @MarshalsPointer
        public static long toNative(Class<? extends ObjCObject> o, long flags) {
            if (o == null) {
                return 0L;
            }
            ObjCClass c = ObjCClass.getByType(o);
            return c.getHandle();
        }
    }
}

