/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.objc;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.IdentityHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.robovm.objc.ObjCRuntime;
import org.robovm.rt.VM;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.annotation.StructMember;

public final class ObjCBlock
extends Struct<ObjCBlock> {
    @StructMember(value=0)
    @Pointer
    public native long isa();

    @StructMember(value=0)
    public native ObjCBlock isa(@Pointer long var1);

    @StructMember(value=1)
    public native int flags();

    @StructMember(value=1)
    public native ObjCBlock flags(int var1);

    @StructMember(value=2)
    public native int reserved();

    @StructMember(value=2)
    public native ObjCBlock reserved(int var1);

    @StructMember(value=3)
    @Pointer
    public native long invoke();

    @StructMember(value=3)
    public native ObjCBlock invoke(@Pointer long var1);

    @StructMember(value=4)
    public native Descriptor descriptor();

    @StructMember(value=4)
    public native ObjCBlock descriptor(Descriptor var1);

    @StructMember(value=5)
    @Pointer
    public native long object_addr();

    @StructMember(value=5)
    public native ObjCBlock object_addr(@Pointer long var1);

    @StructMember(value=6)
    @Pointer
    public native long wrapper_addr();

    @StructMember(value=6)
    public native ObjCBlock wrapper_addr(@Pointer long var1);

    public Object object() {
        return VM.castAddressToObject((long)this.object_addr());
    }

    public ObjCBlock object(Object o) {
        this.object_addr(VM.getObjectAddress((Object)o));
        return this;
    }

    public Wrapper wrapper() {
        return (Wrapper)VM.castAddressToObject((long)this.wrapper_addr());
    }

    public ObjCBlock wrapper(Wrapper o) {
        this.wrapper_addr(VM.getObjectAddress((Object)o));
        return this;
    }

    public boolean hasObject() {
        return this.descriptor().getHandle() == Wrapper.DESCRIPTOR.getHandle();
    }

    public static final class Wrapper {
        private static final Descriptor DESCRIPTOR;
        private static final long NSStackBlock;
        private static final int BLOCK_HAS_COPY_DISPOSE = 0x2000000;
        private static final int BLOCK_HAS_STRET = 0x20000000;
        private static final int BLOCK_HAS_SIGNATURE = 0x40000000;
        private final long callbackImpl;
        private final int flags;
        private final IdentityHashMap<Object, AtomicInteger> refCounts = new IdentityHashMap();

        public Wrapper(Class<?> callbacks) {
            this(Wrapper.findCallback(callbacks), false);
        }

        public Wrapper(Method method) {
            this(method, true);
        }

        public Wrapper(Class<?> cls, String methodName) {
            this(Wrapper.findCallback(cls, methodName), true);
        }

        private Wrapper(Method method, boolean validate) {
            if (validate && method.getAnnotation(Callback.class) == null) {
                throw new IllegalArgumentException("Method " + method + " is not a @Callback method");
            }
            this.callbackImpl = VM.getCallbackMethodImpl((Method)method);
            int flags = 0x42000000;
            if (ObjCRuntime.isStret(method)) {
                flags |= 0x20000000;
            }
            this.flags = flags;
        }

        private static Method findCallback(Class<?> cls, String methodName) {
            for (Method m : cls.getDeclaredMethods()) {
                if (!m.getName().equals(methodName)) continue;
                return m;
            }
            throw new NoSuchMethodError(methodName);
        }

        private static Method findCallback(Class<?> cls) {
            Method method = null;
            for (Method m : cls.getDeclaredMethods()) {
                if (m.getAnnotation(Callback.class) == null) continue;
                if (method != null) {
                    throw new IllegalArgumentException("Several @Callback methods found in class " + cls.getName());
                }
                method = m;
            }
            if (method == null) {
                throw new IllegalArgumentException("No @Callback method found in class " + cls.getName());
            }
            return method;
        }

        public static void initWrappers(Class<?> cls) {
            try {
                for (Method m : cls.getDeclaredMethods()) {
                    if (!m.getName().startsWith("$cb$block$")) continue;
                    Field f = cls.getDeclaredField(m.getName() + "$wrapper");
                    f.setAccessible(true);
                    f.set(null, new Wrapper(m, true));
                }
            }
            catch (Throwable t) {
                throw new Error(t);
            }
        }

        public Object toObject(long handle) {
            ObjCBlock block = (ObjCBlock)Struct.toStruct(ObjCBlock.class, (long)handle);
            if (block == null) {
                return null;
            }
            return block.object();
        }

        public ObjCBlock toObjCBlock(Object o) {
            if (o == null) {
                return null;
            }
            ObjCBlock block = new ObjCBlock().isa(NSStackBlock).flags(this.flags).invoke(this.callbackImpl).descriptor(DESCRIPTOR).object(o).wrapper(this);
            return block;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Callback
        private static void copy(ObjCBlock dst, ObjCBlock src) {
            IdentityHashMap<Object, AtomicInteger> refCounts;
            Object blockObj = src.object();
            Wrapper wrapper = src.wrapper();
            IdentityHashMap<Object, AtomicInteger> identityHashMap = refCounts = wrapper.refCounts;
            synchronized (identityHashMap) {
                AtomicInteger count = refCounts.get(blockObj);
                if (count == null) {
                    count = new AtomicInteger(0);
                    refCounts.put(blockObj, count);
                }
                count.incrementAndGet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Callback
        private static void dispose(ObjCBlock block) {
            IdentityHashMap<Object, AtomicInteger> refCounts;
            Object blockObj = block.object();
            Wrapper wrapper = block.wrapper();
            IdentityHashMap<Object, AtomicInteger> identityHashMap = refCounts = wrapper.refCounts;
            synchronized (identityHashMap) {
                if (refCounts.get(blockObj).decrementAndGet() == 0) {
                    refCounts.remove(blockObj);
                }
            }
        }

        static {
            try {
                long copyImpl = VM.getCallbackMethodImpl((Method)Wrapper.class.getDeclaredMethod("copy", ObjCBlock.class, ObjCBlock.class));
                long disposeImpl = VM.getCallbackMethodImpl((Method)Wrapper.class.getDeclaredMethod("dispose", ObjCBlock.class));
                DESCRIPTOR = new Descriptor().literal_size(ObjCBlock.sizeOf()).copy_helper(copyImpl).dispose_helper(disposeImpl);
            }
            catch (Exception e) {
                throw new Error(e);
            }
            NSStackBlock = ObjCRuntime.objc_getClass(VM.getStringUTFChars((String)"__NSStackBlock__"));
            if (NSStackBlock == 0L) {
                throw new Error("Objective-C class __NSStackBlock__ not found");
            }
        }
    }

    public static final class Descriptor
    extends Struct<Descriptor> {
        @StructMember(value=0)
        @MachineSizedUInt
        public native long reserved();

        @StructMember(value=0)
        public native Descriptor reserved(@MachineSizedUInt long var1);

        @StructMember(value=1)
        @MachineSizedUInt
        public native long literal_size();

        @StructMember(value=1)
        public native Descriptor literal_size(@MachineSizedUInt long var1);

        @StructMember(value=2)
        @Pointer
        public native long copy_helper();

        @StructMember(value=2)
        public native Descriptor copy_helper(@Pointer long var1);

        @StructMember(value=3)
        @Pointer
        public native long dispose_helper();

        @StructMember(value=3)
        public native Descriptor dispose_helper(@Pointer long var1);
    }
}

