/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.routing;

import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Status;
import org.restlet.resource.Directory;
import org.restlet.resource.Finder;
import org.restlet.routing.Filter;
import org.restlet.routing.Route;
import org.restlet.util.RouteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Router
extends Restlet {
    @Deprecated
    public static final int BEST = 1;
    @Deprecated
    public static final int CUSTOM = 6;
    @Deprecated
    public static final int FIRST = 2;
    @Deprecated
    public static final int LAST = 3;
    public static final int MODE_BEST_MATCH = 1;
    public static final int MODE_CUSTOM = 6;
    public static final int MODE_FIRST_MATCH = 2;
    public static final int MODE_LAST_MATCH = 3;
    public static final int MODE_NEXT_MATCH = 4;
    public static final int MODE_RANDOM_MATCH = 5;
    @Deprecated
    public static final int NEXT = 4;
    @Deprecated
    public static final int RANDOM = 5;
    private volatile int defaultMatchingMode = 2;
    private volatile boolean defaultMatchingQuery = false;
    private volatile Route defaultRoute = null;
    private volatile Class<? extends Finder> finderClass = Finder.class;
    private volatile int maxAttempts = 1;
    private volatile float requiredScore = 0.5f;
    private volatile long retryDelay = 500L;
    private volatile RouteList routes = new RouteList();
    private volatile int routingMode = 2;

    public Router() {
        this(null);
    }

    public Router(Context context) {
        super(context);
    }

    public Route attach(Restlet target) {
        return this.attach(target, this.getMatchingMode(target));
    }

    public Route attach(Restlet target, int matchingMode) {
        return this.attach("", target, matchingMode);
    }

    public Route attach(String pathTemplate, Class<?> targetClass) {
        return this.attach(pathTemplate, this.createFinder(targetClass));
    }

    public Route attach(String pathTemplate, Class<?> targetClass, int matchingMode) {
        return this.attach(pathTemplate, this.createFinder(targetClass), matchingMode);
    }

    public Route attach(String pathTemplate, Restlet target) {
        return this.attach(pathTemplate, target, this.getMatchingMode(target));
    }

    public Route attach(String pathTemplate, Restlet target, int matchingMode) {
        Route result = this.createRoute(pathTemplate, target, matchingMode);
        this.getRoutes().add(result);
        return result;
    }

    public Route attachDefault(Class<?> defaultTargetClass) {
        return this.attachDefault(this.createFinder(defaultTargetClass));
    }

    public Route attachDefault(Restlet defaultTarget) {
        Route result = this.createRoute("", defaultTarget);
        result.setMatchingMode(1);
        this.setDefaultRoute(result);
        return result;
    }

    public Finder createFinder(Class<?> targetClass) {
        return Finder.createFinder(targetClass, this.getFinderClass(), this.getContext(), this.getLogger());
    }

    protected Route createRoute(String uriPattern, Restlet target) {
        return this.createRoute(uriPattern, target, this.getMatchingMode(target));
    }

    protected Route createRoute(String uriPattern, Restlet target, int matchingMode) {
        Route result = new Route(this, uriPattern, target);
        result.getTemplate().setMatchingMode(matchingMode);
        result.setMatchingQuery(this.getDefaultMatchingQuery());
        return result;
    }

    public void detach(Class<?> targetClass) {
        Finder finder;
        Restlet target;
        for (int i = this.getRoutes().size() - 1; i >= 0; --i) {
            Finder finder2;
            Restlet target2 = ((Route)this.getRoutes().get(i)).getNext();
            if (target2 == null || !Finder.class.isAssignableFrom(target2.getClass()) || !(finder2 = (Finder)target2).getTargetClass().equals(targetClass)) continue;
            this.getRoutes().remove(i);
        }
        if (this.getDefaultRoute() != null && (target = this.getDefaultRoute().getNext()) != null && Finder.class.isAssignableFrom(target.getClass()) && (finder = (Finder)target).getTargetClass().equals(targetClass)) {
            this.setDefaultRoute(null);
        }
    }

    public void detach(Restlet target) {
        this.getRoutes().removeAll(target);
        if (this.getDefaultRoute() != null && this.getDefaultRoute().getNext() == target) {
            this.setDefaultRoute(null);
        }
    }

    protected void doHandle(Restlet next, Request request, Response response) {
        next.handle(request, response);
    }

    protected Route getCustom(Request request, Response response) {
        return null;
    }

    public int getDefaultMatchingMode() {
        return this.defaultMatchingMode;
    }

    public boolean getDefaultMatchingQuery() {
        return this.getDefaultMatchQuery();
    }

    @Deprecated
    public boolean getDefaultMatchQuery() {
        return this.defaultMatchingQuery;
    }

    public Route getDefaultRoute() {
        return this.defaultRoute;
    }

    public Class<? extends Finder> getFinderClass() {
        return this.finderClass;
    }

    protected int getMatchingMode(Restlet target) {
        int result = this.getDefaultMatchingMode();
        if (target instanceof Directory || target instanceof Router) {
            result = 1;
        } else if (target instanceof Filter) {
            result = this.getMatchingMode(((Filter)target).getNext());
        }
        return result;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public Restlet getNext(Request request, Response response) {
        Route result = null;
        block10: for (int i = 0; result == null && i < this.getMaxAttempts(); ++i) {
            if (i > 0) {
                try {
                    Thread.sleep(this.getRetryDelay());
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (this.routes == null) continue;
            switch (this.getRoutingMode()) {
                case 1: {
                    result = this.getRoutes().getBest(request, response, this.getRequiredScore());
                    continue block10;
                }
                case 2: {
                    result = this.getRoutes().getFirst(request, response, this.getRequiredScore());
                    continue block10;
                }
                case 3: {
                    result = this.getRoutes().getLast(request, response, this.getRequiredScore());
                    continue block10;
                }
                case 4: {
                    result = this.getRoutes().getNext(request, response, this.getRequiredScore());
                    continue block10;
                }
                case 5: {
                    result = this.getRoutes().getRandom(request, response, this.getRequiredScore());
                    continue block10;
                }
                case 6: {
                    result = this.getCustom(request, response);
                }
            }
        }
        if (result == null) {
            if (this.getDefaultRoute() != null && this.getDefaultRoute().score(request, response) >= this.getRequiredScore()) {
                result = this.getDefaultRoute();
            } else {
                response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            }
        }
        this.logRoute(result);
        return result;
    }

    public float getRequiredScore() {
        return this.requiredScore;
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }

    public RouteList getRoutes() {
        return this.routes;
    }

    public int getRoutingMode() {
        return this.routingMode;
    }

    @Override
    public void handle(Request request, Response response) {
        super.handle(request, response);
        Restlet next = this.getNext(request, response);
        if (next != null) {
            this.doHandle(next, request, response);
        } else {
            response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        }
    }

    protected void logRoute(Route route) {
        if (this.getLogger().isLoggable(Level.FINE)) {
            if (this.getDefaultRoute() == route) {
                this.getLogger().fine("The default route was selected.");
            } else {
                this.getLogger().fine("This route was selected: " + route);
            }
        }
    }

    public void setDefaultMatchingMode(int defaultMatchingMode) {
        this.defaultMatchingMode = defaultMatchingMode;
    }

    public void setDefaultMatchingQuery(boolean defaultMatchingQuery) {
        this.setDefaultMatchQuery(defaultMatchingQuery);
    }

    @Deprecated
    public void setDefaultMatchQuery(boolean defaultMatchingQuery) {
        this.defaultMatchingQuery = defaultMatchingQuery;
    }

    public void setDefaultRoute(Route defaultRoute) {
        this.defaultRoute = defaultRoute;
    }

    public void setFinderClass(Class<? extends Finder> finderClass) {
        this.finderClass = finderClass;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public void setRequiredScore(float score) {
        this.requiredScore = score;
    }

    public void setRetryDelay(long retryDelay) {
        this.retryDelay = retryDelay;
    }

    public void setRoutes(RouteList routes) {
        this.routes = routes;
    }

    public void setRoutingMode(int routingMode) {
        this.routingMode = routingMode;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.isStopped()) {
            for (Route route : this.getRoutes()) {
                route.start();
            }
            if (this.getDefaultRoute() != null) {
                this.getDefaultRoute().start();
            }
            super.start();
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        if (this.isStarted()) {
            super.stop();
            if (this.getDefaultRoute() != null) {
                this.getDefaultRoute().stop();
            }
            for (Route route : this.getRoutes()) {
                route.stop();
            }
        }
    }
}

