/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.classpath.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.ops4j.pax.url.classpath.internal.Parser;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import shaded.org.ops4j.lang.NullArgumentException;

public class Connection
extends URLConnection {
    public static final String PROTOCOL = "classpath";
    private final BundleContext m_bundleContext;
    private Parser m_parser;

    public Connection(URL url, BundleContext bundleContext) throws MalformedURLException {
        super(url);
        NullArgumentException.validateNotNull(url, "URL");
        this.m_bundleContext = bundleContext;
        this.m_parser = new Parser(url.getPath());
    }

    @Override
    public void connect() {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream is;
        this.connect();
        if (this.url.getAuthority() != null) {
            is = this.getFromSpecificBundle();
        } else {
            is = this.getFromClasspath();
            if (is == null) {
                is = this.getFromInstalledBundles();
            }
        }
        if (is == null) {
            throw new IOException("URL [" + this.m_parser.getResourceName() + "] could not be resolved from classpath");
        }
        return is;
    }

    private InputStream getFromSpecificBundle() throws IOException {
        URL resource;
        Bundle[] bundles = this.getBundles(this.url.getAuthority());
        if (bundles != null && bundles.length > 0 && (resource = bundles[0].getResource(this.m_parser.getResourceName())) != null) {
            return resource.openStream();
        }
        return null;
    }

    private InputStream getFromClasspath() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            return cl.getResourceAsStream(this.m_parser.getResourceName());
        }
        return null;
    }

    private InputStream getFromInstalledBundles() throws IOException {
        Bundle[] bundles = this.getBundles(null);
        if (bundles != null && bundles.length > 0) {
            for (Bundle bundle : bundles) {
                URL resource = bundle.getResource(this.m_parser.getResourceName());
                if (resource == null) continue;
                return resource.openStream();
            }
        }
        return null;
    }

    private Bundle[] getBundles(String symbolicName) {
        if (this.m_bundleContext == null) {
            return null;
        }
        Bundle[] bundles = this.m_bundleContext.getBundles();
        if (bundles != null && symbolicName != null) {
            for (Bundle bundle : bundles) {
                if (!bundle.getSymbolicName().equals(symbolicName)) continue;
                return new Bundle[]{bundle};
            }
        }
        return bundles;
    }
}

