/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

package org.opensearch.client.opensearch.indices;

import java.util.Collections;
import java.util.function.Function;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

// typedef: indices.delete_index_template.Request

/**
 * Deletes an index template.
 *
 */

public class DeleteIndexTemplateRequest extends RequestBase {
    private final String name;

    // ---------------------------------------------------------------------------------------------

    private DeleteIndexTemplateRequest(Builder builder) {

        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");

    }

    public static DeleteIndexTemplateRequest of(Function<Builder, ObjectBuilder<DeleteIndexTemplateRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    /**
     * Required - The name of the template
     * <p>
     * API name: {@code name}
     */
    public final String name() {
        return this.name;
    }

    // ---------------------------------------------------------------------------------------------

    /**
     * Builder for {@link DeleteIndexTemplateRequest}.
     */

    public static class Builder extends ObjectBuilderBase implements ObjectBuilder<DeleteIndexTemplateRequest> {
        private String name;

        /**
         * Required - The name of the template
         * <p>
         * API name: {@code name}
         */
        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        /**
         * Builds a {@link DeleteIndexTemplateRequest}.
         *
         * @throws NullPointerException
         *             if some of the required fields are null.
         */
        public DeleteIndexTemplateRequest build() {
            _checkSingleUse();

            return new DeleteIndexTemplateRequest(this);
        }
    }

    // ---------------------------------------------------------------------------------------------

    /**
     * Endpoint "{@code indices.delete_index_template}".
     */
    public static final Endpoint<DeleteIndexTemplateRequest, DeleteIndexTemplateResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<>(

        // Request method
        request -> {
            return "DELETE";

        },

        // Request path
        request -> {
            final int _name = 1 << 0;

            int propsSet = 0;

            propsSet |= _name;

            if (propsSet == (_name)) {
                StringBuilder buf = new StringBuilder();
                buf.append("/_index_template");
                buf.append("/");
                SimpleEndpoint.pathEncode(request.name, buf);
                return buf.toString();
            }
            throw SimpleEndpoint.noPathTemplateFound("path");

        },

        // Request parameters
        request -> {
            return Collections.emptyMap();

        },
        SimpleEndpoint.emptyMap(),
        false,
        DeleteIndexTemplateResponse._DESERIALIZER
    );
}
