/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where.render;

import java.util.Objects;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.AbstractColumnComparisonCondition;
import org.mybatis.dynamic.sql.AbstractListValueCondition;
import org.mybatis.dynamic.sql.AbstractNoValueCondition;
import org.mybatis.dynamic.sql.AbstractSingleValueCondition;
import org.mybatis.dynamic.sql.AbstractSubselectCondition;
import org.mybatis.dynamic.sql.AbstractTwoValueCondition;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.ConditionVisitor;
import org.mybatis.dynamic.sql.render.RenderedParameterInfo;
import org.mybatis.dynamic.sql.render.RenderingContext;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.FragmentCollector;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class DefaultConditionVisitor<T>
implements ConditionVisitor<T, FragmentAndParameters> {
    private final BindableColumn<T> column;
    private final RenderingContext renderingContext;

    private DefaultConditionVisitor(Builder<T> builder) {
        this.column = Objects.requireNonNull(((Builder)builder).column);
        this.renderingContext = Objects.requireNonNull(((Builder)builder).renderingContext);
    }

    @Override
    public FragmentAndParameters visit(AbstractListValueCondition<T> condition) {
        FragmentCollector fc = condition.values().map(this::toFragmentAndParameters).collect(FragmentCollector.collect());
        String joinedFragments = fc.collectFragments(Collectors.joining(",", "(", ")"));
        String finalFragment = condition.operator() + StringUtilities.spaceBefore(joinedFragments);
        return FragmentAndParameters.withFragment(finalFragment).withParameters(fc.parameters()).build();
    }

    @Override
    public FragmentAndParameters visit(AbstractNoValueCondition<T> condition) {
        return FragmentAndParameters.fromFragment(condition.operator());
    }

    @Override
    public FragmentAndParameters visit(AbstractSingleValueCondition<T> condition) {
        RenderedParameterInfo parameterInfo = this.renderingContext.calculateParameterInfo(this.column);
        String finalFragment = condition.operator() + StringUtilities.spaceBefore(parameterInfo.renderedPlaceHolder());
        return FragmentAndParameters.withFragment(finalFragment).withParameter(parameterInfo.parameterMapKey(), this.convertValue(condition.value())).build();
    }

    @Override
    public FragmentAndParameters visit(AbstractTwoValueCondition<T> condition) {
        RenderedParameterInfo parameterInfo1 = this.renderingContext.calculateParameterInfo(this.column);
        RenderedParameterInfo parameterInfo2 = this.renderingContext.calculateParameterInfo(this.column);
        String finalFragment = condition.operator1() + StringUtilities.spaceBefore(parameterInfo1.renderedPlaceHolder()) + StringUtilities.spaceBefore(condition.operator2()) + StringUtilities.spaceBefore(parameterInfo2.renderedPlaceHolder());
        return FragmentAndParameters.withFragment(finalFragment).withParameter(parameterInfo1.parameterMapKey(), this.convertValue(condition.value1())).withParameter(parameterInfo2.parameterMapKey(), this.convertValue(condition.value2())).build();
    }

    @Override
    public FragmentAndParameters visit(AbstractSubselectCondition<T> condition) {
        SelectStatementProvider selectStatement = condition.selectModel().render(this.renderingContext);
        String finalFragment = condition.operator() + " (" + selectStatement.getSelectStatement() + ")";
        return FragmentAndParameters.withFragment(finalFragment).withParameters(selectStatement.getParameters()).build();
    }

    @Override
    public FragmentAndParameters visit(AbstractColumnComparisonCondition<T> condition) {
        FragmentAndParameters renderedRightColumn = condition.rightColumn().render(this.renderingContext);
        String finalFragment = condition.operator() + StringUtilities.spaceBefore(renderedRightColumn.fragment());
        return FragmentAndParameters.withFragment(finalFragment).withParameters(renderedRightColumn.parameters()).build();
    }

    private Object convertValue(T value) {
        return this.column.convertParameterType(value);
    }

    private FragmentAndParameters toFragmentAndParameters(T value) {
        RenderedParameterInfo parameterInfo = this.renderingContext.calculateParameterInfo(this.column);
        return FragmentAndParameters.withFragment(parameterInfo.renderedPlaceHolder()).withParameter(parameterInfo.parameterMapKey(), this.convertValue(value)).build();
    }

    public static <T> Builder<T> withColumn(BindableColumn<T> column) {
        return new Builder<T>().withColumn(column);
    }

    public static class Builder<T> {
        private BindableColumn<T> column;
        private RenderingContext renderingContext;

        public Builder<T> withColumn(BindableColumn<T> column) {
            this.column = column;
            return this;
        }

        public Builder<T> withRenderingContext(RenderingContext renderingContext) {
            this.renderingContext = renderingContext;
            return this;
        }

        public DefaultConditionVisitor<T> build() {
            return new DefaultConditionVisitor(this);
        }
    }
}

