/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where;

import java.util.Objects;
import java.util.Optional;
import org.mybatis.dynamic.sql.common.AbstractBooleanExpressionModel;
import org.mybatis.dynamic.sql.configuration.StatementConfiguration;
import org.mybatis.dynamic.sql.render.RenderingContext;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.where.render.WhereClauseProvider;
import org.mybatis.dynamic.sql.where.render.WhereRenderer;

public class WhereModel
extends AbstractBooleanExpressionModel {
    private final StatementConfiguration statementConfiguration;

    private WhereModel(Builder builder) {
        super(builder);
        this.statementConfiguration = Objects.requireNonNull(builder.statementConfiguration);
    }

    public Optional<WhereClauseProvider> render(RenderingStrategy renderingStrategy) {
        RenderingContext renderingContext = RenderingContext.withRenderingStrategy(renderingStrategy).withStatementConfiguration(this.statementConfiguration).build();
        return this.render(renderingContext);
    }

    public Optional<WhereClauseProvider> render(RenderingStrategy renderingStrategy, TableAliasCalculator tableAliasCalculator) {
        RenderingContext renderingContext = RenderingContext.withRenderingStrategy(renderingStrategy).withTableAliasCalculator(tableAliasCalculator).withStatementConfiguration(this.statementConfiguration).build();
        return this.render(renderingContext);
    }

    public Optional<WhereClauseProvider> render(RenderingStrategy renderingStrategy, String parameterName) {
        RenderingContext renderingContext = RenderingContext.withRenderingStrategy(renderingStrategy).withParameterName(parameterName).withStatementConfiguration(this.statementConfiguration).build();
        return this.render(renderingContext);
    }

    public Optional<WhereClauseProvider> render(RenderingStrategy renderingStrategy, TableAliasCalculator tableAliasCalculator, String parameterName) {
        RenderingContext renderingContext = RenderingContext.withRenderingStrategy(renderingStrategy).withTableAliasCalculator(tableAliasCalculator).withParameterName(parameterName).withStatementConfiguration(this.statementConfiguration).build();
        return this.render(renderingContext);
    }

    private Optional<WhereClauseProvider> render(RenderingContext renderingContext) {
        return ((WhereRenderer.Builder)WhereRenderer.withWhereModel(this).withRenderingContext(renderingContext)).build().render().map(this::toWhereClauseProvider);
    }

    private WhereClauseProvider toWhereClauseProvider(FragmentAndParameters fragmentAndParameters) {
        return WhereClauseProvider.withWhereClause(fragmentAndParameters.fragment()).withParameters(fragmentAndParameters.parameters()).build();
    }

    public static class Builder
    extends AbstractBooleanExpressionModel.AbstractBuilder<Builder> {
        private StatementConfiguration statementConfiguration;

        public Builder withStatementConfiguration(StatementConfiguration statementConfiguration) {
            this.statementConfiguration = statementConfiguration;
            return this;
        }

        public WhereModel build() {
            return new WhereModel(this);
        }

        @Override
        protected Builder getThis() {
            return this;
        }
    }
}

