/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collector;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;

public class FragmentCollector {
    final List<FragmentAndParameters> fragments = new ArrayList<FragmentAndParameters>();

    public FragmentCollector() {
    }

    private FragmentCollector(FragmentAndParameters initialFragment) {
        this.add(initialFragment);
    }

    public void add(FragmentAndParameters fragmentAndParameters) {
        this.fragments.add(fragmentAndParameters);
    }

    public FragmentCollector merge(FragmentCollector other) {
        this.fragments.addAll(other.fragments);
        return this;
    }

    public Optional<String> firstFragment() {
        return this.fragments.stream().findFirst().map(FragmentAndParameters::fragment);
    }

    public String collectFragments(Collector<CharSequence, ?, String> fragmentCollector) {
        return this.fragments.stream().map(FragmentAndParameters::fragment).collect(fragmentCollector);
    }

    public FragmentAndParameters toFragmentAndParameters(Collector<CharSequence, ?, String> fragmentCollector) {
        return FragmentAndParameters.withFragment(this.collectFragments(fragmentCollector)).withParameters(this.parameters()).build();
    }

    public Map<String, Object> parameters() {
        return this.fragments.stream().map(FragmentAndParameters::parameters).collect(HashMap::new, HashMap::putAll, HashMap::putAll);
    }

    public boolean hasMultipleFragments() {
        return this.fragments.size() > 1;
    }

    public boolean isEmpty() {
        return this.fragments.isEmpty();
    }

    public static Collector<FragmentAndParameters, FragmentCollector, FragmentCollector> collect() {
        return Collector.of(FragmentCollector::new, FragmentCollector::add, FragmentCollector::merge, new Collector.Characteristics[0]);
    }

    public static Collector<FragmentAndParameters, FragmentCollector, FragmentCollector> collect(FragmentAndParameters initialFragment) {
        return Collector.of(() -> new FragmentCollector(initialFragment), FragmentCollector::add, FragmentCollector::merge, new Collector.Characteristics[0]);
    }
}

