/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.update.render;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.common.OrderByModel;
import org.mybatis.dynamic.sql.common.OrderByRenderer;
import org.mybatis.dynamic.sql.configuration.StatementConfiguration;
import org.mybatis.dynamic.sql.render.ExplicitTableAliasCalculator;
import org.mybatis.dynamic.sql.render.RenderedParameterInfo;
import org.mybatis.dynamic.sql.render.RenderingContext;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;
import org.mybatis.dynamic.sql.update.UpdateModel;
import org.mybatis.dynamic.sql.update.render.DefaultUpdateStatementProvider;
import org.mybatis.dynamic.sql.update.render.SetPhraseVisitor;
import org.mybatis.dynamic.sql.update.render.UpdateStatementProvider;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.FragmentCollector;
import org.mybatis.dynamic.sql.util.Validator;
import org.mybatis.dynamic.sql.where.EmbeddedWhereModel;

public class UpdateRenderer {
    private final UpdateModel updateModel;
    private final RenderingContext renderingContext;
    private final SetPhraseVisitor visitor;

    private UpdateRenderer(Builder builder) {
        this.updateModel = Objects.requireNonNull(builder.updateModel);
        TableAliasCalculator tableAliasCalculator = builder.updateModel.tableAlias().map(a -> ExplicitTableAliasCalculator.of(this.updateModel.table(), a)).orElseGet(TableAliasCalculator::empty);
        this.renderingContext = RenderingContext.withRenderingStrategy(Objects.requireNonNull(builder.renderingStrategy)).withTableAliasCalculator(tableAliasCalculator).withStatementConfiguration(builder.statementConfiguration).build();
        this.visitor = new SetPhraseVisitor(this.renderingContext);
    }

    public UpdateStatementProvider render() {
        FragmentCollector fragmentCollector = new FragmentCollector();
        fragmentCollector.add(this.calculateUpdateStatementStart());
        fragmentCollector.add(this.calculateSetPhrase());
        this.calculateWhereClause().ifPresent(fragmentCollector::add);
        this.calculateOrderByClause().ifPresent(fragmentCollector::add);
        this.calculateLimitClause().ifPresent(fragmentCollector::add);
        return this.toUpdateStatementProvider(fragmentCollector);
    }

    private UpdateStatementProvider toUpdateStatementProvider(FragmentCollector fragmentCollector) {
        return DefaultUpdateStatementProvider.withUpdateStatement(fragmentCollector.collectFragments(Collectors.joining(" "))).withParameters(fragmentCollector.parameters()).build();
    }

    private FragmentAndParameters calculateUpdateStatementStart() {
        String aliasedTableName = this.renderingContext.aliasedTableName(this.updateModel.table());
        return FragmentAndParameters.fromFragment("update " + aliasedTableName);
    }

    private FragmentAndParameters calculateSetPhrase() {
        List fragmentsAndParameters = this.updateModel.columnMappings().map(m -> m.accept(this.visitor)).collect(Collectors.toList());
        Validator.assertFalse(fragmentsAndParameters.stream().noneMatch(Optional::isPresent), "ERROR.18");
        FragmentCollector fragmentCollector = fragmentsAndParameters.stream().filter(Optional::isPresent).map(Optional::get).collect(FragmentCollector.collect());
        return this.toSetPhrase(fragmentCollector);
    }

    private FragmentAndParameters toSetPhrase(FragmentCollector fragmentCollector) {
        return fragmentCollector.toFragmentAndParameters(Collectors.joining(", ", "set ", ""));
    }

    private Optional<FragmentAndParameters> calculateWhereClause() {
        return this.updateModel.whereModel().flatMap(this::renderWhereClause);
    }

    private Optional<FragmentAndParameters> renderWhereClause(EmbeddedWhereModel whereModel) {
        return whereModel.render(this.renderingContext);
    }

    private Optional<FragmentAndParameters> calculateLimitClause() {
        return this.updateModel.limit().map(this::renderLimitClause);
    }

    private FragmentAndParameters renderLimitClause(Long limit) {
        RenderedParameterInfo parameterInfo = this.renderingContext.calculateParameterInfo();
        return FragmentAndParameters.withFragment("limit " + parameterInfo.renderedPlaceHolder()).withParameter(parameterInfo.parameterMapKey(), limit).build();
    }

    private Optional<FragmentAndParameters> calculateOrderByClause() {
        return this.updateModel.orderByModel().map(this::renderOrderByClause);
    }

    private FragmentAndParameters renderOrderByClause(OrderByModel orderByModel) {
        return new OrderByRenderer().render(orderByModel);
    }

    public static Builder withUpdateModel(UpdateModel updateModel) {
        return new Builder().withUpdateModel(updateModel);
    }

    public static class Builder {
        private UpdateModel updateModel;
        private RenderingStrategy renderingStrategy;
        private StatementConfiguration statementConfiguration;

        public Builder withUpdateModel(UpdateModel updateModel) {
            this.updateModel = updateModel;
            return this;
        }

        public Builder withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public Builder withStatementConfiguration(StatementConfiguration statementConfiguration) {
            this.statementConfiguration = statementConfiguration;
            return this;
        }

        public UpdateRenderer build() {
            return new UpdateRenderer(this);
        }
    }
}

