/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.update.render;

import java.util.Objects;
import java.util.Optional;
import org.mybatis.dynamic.sql.render.RenderedParameterInfo;
import org.mybatis.dynamic.sql.render.RenderingContext;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.util.AbstractColumnMapping;
import org.mybatis.dynamic.sql.util.ColumnToColumnMapping;
import org.mybatis.dynamic.sql.util.ConstantMapping;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.NullMapping;
import org.mybatis.dynamic.sql.util.SelectMapping;
import org.mybatis.dynamic.sql.util.StringConstantMapping;
import org.mybatis.dynamic.sql.util.StringUtilities;
import org.mybatis.dynamic.sql.util.UpdateMappingVisitor;
import org.mybatis.dynamic.sql.util.ValueMapping;
import org.mybatis.dynamic.sql.util.ValueOrNullMapping;
import org.mybatis.dynamic.sql.util.ValueWhenPresentMapping;

public class SetPhraseVisitor
extends UpdateMappingVisitor<Optional<FragmentAndParameters>> {
    private final RenderingContext renderingContext;

    public SetPhraseVisitor(RenderingContext renderingContext) {
        this.renderingContext = Objects.requireNonNull(renderingContext);
    }

    @Override
    public Optional<FragmentAndParameters> visit(NullMapping mapping) {
        return this.buildNullFragment(mapping);
    }

    @Override
    public Optional<FragmentAndParameters> visit(ConstantMapping mapping) {
        String fragment = this.renderingContext.aliasedColumnName(mapping.column()) + " = " + mapping.constant();
        return FragmentAndParameters.withFragment(fragment).buildOptional();
    }

    @Override
    public Optional<FragmentAndParameters> visit(StringConstantMapping mapping) {
        String fragment = this.renderingContext.aliasedColumnName(mapping.column()) + " = " + StringUtilities.formatConstantForSQL(mapping.constant());
        return FragmentAndParameters.withFragment(fragment).buildOptional();
    }

    @Override
    public <T> Optional<FragmentAndParameters> visit(ValueMapping<T> mapping) {
        return this.buildValueFragment(mapping, mapping.value());
    }

    @Override
    public <T> Optional<FragmentAndParameters> visit(ValueOrNullMapping<T> mapping) {
        return mapping.value().map(v -> this.buildValueFragment(mapping, v)).orElseGet(() -> this.buildNullFragment(mapping));
    }

    @Override
    public <T> Optional<FragmentAndParameters> visit(ValueWhenPresentMapping<T> mapping) {
        return mapping.value().flatMap(v -> this.buildValueFragment(mapping, v));
    }

    @Override
    public Optional<FragmentAndParameters> visit(SelectMapping mapping) {
        SelectStatementProvider selectStatement = mapping.selectModel().render(this.renderingContext);
        String fragment = this.renderingContext.aliasedColumnName(mapping.column()) + " = (" + selectStatement.getSelectStatement() + ")";
        return FragmentAndParameters.withFragment(fragment).withParameters(selectStatement.getParameters()).buildOptional();
    }

    @Override
    public Optional<FragmentAndParameters> visit(ColumnToColumnMapping mapping) {
        FragmentAndParameters renderedColumn = mapping.rightColumn().render(this.renderingContext);
        String setPhrase = this.renderingContext.aliasedColumnName(mapping.column()) + " = " + renderedColumn.fragment();
        return FragmentAndParameters.withFragment(setPhrase).withParameters(renderedColumn.parameters()).buildOptional();
    }

    private <T> Optional<FragmentAndParameters> buildValueFragment(AbstractColumnMapping mapping, T value) {
        RenderedParameterInfo parameterInfo = this.renderingContext.calculateParameterInfo(mapping.column());
        String setPhrase = this.renderingContext.aliasedColumnName(mapping.column()) + " = " + parameterInfo.renderedPlaceHolder();
        return FragmentAndParameters.withFragment(setPhrase).withParameter(parameterInfo.parameterMapKey(), value).buildOptional();
    }

    private Optional<FragmentAndParameters> buildNullFragment(AbstractColumnMapping mapping) {
        return FragmentAndParameters.withFragment(this.renderingContext.aliasedColumnName(mapping.column()) + " = null").buildOptional();
    }
}

