/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.render;

import java.util.Objects;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.TableExpressionVisitor;
import org.mybatis.dynamic.sql.render.RenderingContext;
import org.mybatis.dynamic.sql.select.SubQuery;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class TableExpressionRenderer
implements TableExpressionVisitor<FragmentAndParameters> {
    private final RenderingContext renderingContext;

    private TableExpressionRenderer(Builder builder) {
        this.renderingContext = Objects.requireNonNull(builder.renderingContext);
    }

    @Override
    public FragmentAndParameters visit(SqlTable table) {
        return FragmentAndParameters.fromFragment(this.renderingContext.aliasedTableName(table));
    }

    @Override
    public FragmentAndParameters visit(SubQuery subQuery) {
        SelectStatementProvider selectStatement = subQuery.selectModel().render(this.renderingContext);
        String fragment = "(" + selectStatement.getSelectStatement() + ")";
        fragment = this.applyAlias(fragment, subQuery);
        return FragmentAndParameters.withFragment(fragment).withParameters(selectStatement.getParameters()).build();
    }

    private String applyAlias(String fragment, SubQuery subQuery) {
        return subQuery.alias().map(a -> fragment + StringUtilities.spaceBefore(a)).orElse(fragment);
    }

    public static class Builder {
        private RenderingContext renderingContext;

        public Builder withRenderingContext(RenderingContext renderingContext) {
            this.renderingContext = renderingContext;
            return this;
        }

        public TableExpressionRenderer build() {
            return new TableExpressionRenderer(this);
        }
    }
}

