/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.render;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.TableExpression;
import org.mybatis.dynamic.sql.render.ExplicitTableAliasCalculator;
import org.mybatis.dynamic.sql.render.GuaranteedTableAliasCalculator;
import org.mybatis.dynamic.sql.render.RenderingContext;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;
import org.mybatis.dynamic.sql.select.GroupByModel;
import org.mybatis.dynamic.sql.select.HavingModel;
import org.mybatis.dynamic.sql.select.QueryExpressionModel;
import org.mybatis.dynamic.sql.select.join.JoinModel;
import org.mybatis.dynamic.sql.select.render.HavingRenderer;
import org.mybatis.dynamic.sql.select.render.JoinRenderer;
import org.mybatis.dynamic.sql.select.render.TableExpressionRenderer;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.FragmentCollector;
import org.mybatis.dynamic.sql.util.StringUtilities;
import org.mybatis.dynamic.sql.where.EmbeddedWhereModel;

public class QueryExpressionRenderer {
    private final QueryExpressionModel queryExpression;
    private final TableExpressionRenderer tableExpressionRenderer;
    private final RenderingContext renderingContext;

    private QueryExpressionRenderer(Builder builder) {
        this.queryExpression = Objects.requireNonNull(builder.queryExpression);
        TableAliasCalculator childTableAliasCalculator = this.calculateChildTableAliasCalculator(this.queryExpression);
        this.renderingContext = builder.renderingContext.withChildTableAliasCalculator(childTableAliasCalculator);
        this.tableExpressionRenderer = new TableExpressionRenderer.Builder().withRenderingContext(this.renderingContext).build();
    }

    private TableAliasCalculator calculateChildTableAliasCalculator(QueryExpressionModel queryExpression) {
        return queryExpression.joinModel().map(JoinModel::containsSubQueries).map(this::calculateTableAliasCalculatorWithJoins).orElseGet(this::explicitTableAliasCalculator);
    }

    private TableAliasCalculator calculateTableAliasCalculatorWithJoins(boolean hasSubQueries) {
        if (hasSubQueries) {
            return this.explicitTableAliasCalculator();
        }
        return this.guaranteedTableAliasCalculator();
    }

    private TableAliasCalculator explicitTableAliasCalculator() {
        return ExplicitTableAliasCalculator.of(this.queryExpression.tableAliases());
    }

    private TableAliasCalculator guaranteedTableAliasCalculator() {
        return GuaranteedTableAliasCalculator.of(this.queryExpression.tableAliases());
    }

    public FragmentAndParameters render() {
        FragmentCollector fragmentCollector = new FragmentCollector();
        fragmentCollector.add(this.calculateQueryExpressionStart());
        this.calculateJoinClause().ifPresent(fragmentCollector::add);
        this.calculateWhereClause().ifPresent(fragmentCollector::add);
        this.calculateGroupByClause().ifPresent(fragmentCollector::add);
        this.calculateHavingClause().ifPresent(fragmentCollector::add);
        return fragmentCollector.toFragmentAndParameters(Collectors.joining(" "));
    }

    private FragmentAndParameters calculateQueryExpressionStart() {
        FragmentAndParameters columnList = this.calculateColumnList();
        String start = this.queryExpression.connector().map(StringUtilities::spaceAfter).orElse("") + "select " + (this.queryExpression.isDistinct() ? "distinct " : "") + columnList.fragment() + " from ";
        FragmentAndParameters renderedTable = this.renderTableExpression(this.queryExpression.table());
        start = start + renderedTable.fragment();
        return FragmentAndParameters.withFragment(start).withParameters(renderedTable.parameters()).withParameters(columnList.parameters()).build();
    }

    private FragmentAndParameters calculateColumnList() {
        return this.queryExpression.columns().map(this::renderColumnAndAlias).collect(FragmentCollector.collect()).toFragmentAndParameters(Collectors.joining(", "));
    }

    private FragmentAndParameters renderColumnAndAlias(BasicColumn selectListItem) {
        FragmentAndParameters renderedColumn = selectListItem.render(this.renderingContext);
        String nameAndTableAlias = selectListItem.alias().map(a -> renderedColumn.fragment() + " as " + a).orElse(renderedColumn.fragment());
        return FragmentAndParameters.withFragment(nameAndTableAlias).withParameters(renderedColumn.parameters()).build();
    }

    private FragmentAndParameters renderTableExpression(TableExpression table) {
        return table.accept(this.tableExpressionRenderer);
    }

    private Optional<FragmentAndParameters> calculateJoinClause() {
        return this.queryExpression.joinModel().map(this::renderJoin);
    }

    private FragmentAndParameters renderJoin(JoinModel joinModel) {
        return JoinRenderer.withJoinModel(joinModel).withTableExpressionRenderer(this.tableExpressionRenderer).withRenderingContext(this.renderingContext).build().render();
    }

    private Optional<FragmentAndParameters> calculateWhereClause() {
        return this.queryExpression.whereModel().flatMap(this::renderWhereClause);
    }

    private Optional<FragmentAndParameters> renderWhereClause(EmbeddedWhereModel whereModel) {
        return whereModel.render(this.renderingContext);
    }

    private Optional<FragmentAndParameters> calculateGroupByClause() {
        return this.queryExpression.groupByModel().map(this::renderGroupBy);
    }

    private FragmentAndParameters renderGroupBy(GroupByModel groupByModel) {
        return groupByModel.columns().map(this::renderColumn).collect(FragmentCollector.collect()).toFragmentAndParameters(Collectors.joining(", ", "group by ", ""));
    }

    private FragmentAndParameters renderColumn(BasicColumn column) {
        return column.render(this.renderingContext);
    }

    private Optional<FragmentAndParameters> calculateHavingClause() {
        return this.queryExpression.havingModel().flatMap(this::renderHavingClause);
    }

    private Optional<FragmentAndParameters> renderHavingClause(HavingModel havingModel) {
        return ((HavingRenderer.Builder)HavingRenderer.withHavingModel(havingModel).withRenderingContext(this.renderingContext)).build().render();
    }

    public static Builder withQueryExpression(QueryExpressionModel model) {
        return new Builder().withQueryExpression(model);
    }

    public static class Builder {
        private QueryExpressionModel queryExpression;
        private RenderingContext renderingContext;

        public Builder withRenderingContext(RenderingContext renderingContext) {
            this.renderingContext = renderingContext;
            return this;
        }

        public Builder withQueryExpression(QueryExpressionModel queryExpression) {
            this.queryExpression = queryExpression;
            return this;
        }

        public QueryExpressionRenderer build() {
            return new QueryExpressionRenderer(this);
        }
    }
}

