/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.render;

import java.util.Objects;
import org.mybatis.dynamic.sql.render.RenderedParameterInfo;
import org.mybatis.dynamic.sql.render.RenderingContext;
import org.mybatis.dynamic.sql.select.PagingModel;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;

public class LimitAndOffsetPagingModelRenderer {
    private final RenderingContext renderingContext;
    private final Long limit;
    private final PagingModel pagingModel;

    public LimitAndOffsetPagingModelRenderer(RenderingContext renderingContext, Long limit, PagingModel pagingModel) {
        this.renderingContext = renderingContext;
        this.limit = Objects.requireNonNull(limit);
        this.pagingModel = pagingModel;
    }

    public FragmentAndParameters render() {
        return this.pagingModel.offset().map(this::renderLimitAndOffset).orElseGet(this::renderLimitOnly);
    }

    private FragmentAndParameters renderLimitOnly() {
        RenderedParameterInfo parameterInfo = this.renderingContext.calculateParameterInfo();
        return FragmentAndParameters.withFragment("limit " + parameterInfo.renderedPlaceHolder()).withParameter(parameterInfo.parameterMapKey(), this.limit).build();
    }

    private FragmentAndParameters renderLimitAndOffset(Long offset) {
        RenderedParameterInfo parameterInfo1 = this.renderingContext.calculateParameterInfo();
        RenderedParameterInfo parameterInfo2 = this.renderingContext.calculateParameterInfo();
        return FragmentAndParameters.withFragment("limit " + parameterInfo1.renderedPlaceHolder() + " offset " + parameterInfo2.renderedPlaceHolder()).withParameter(parameterInfo1.parameterMapKey(), this.limit).withParameter(parameterInfo2.parameterMapKey(), offset).build();
    }
}

