/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.render;

import java.util.Objects;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.render.RenderingContext;
import org.mybatis.dynamic.sql.select.join.JoinCriterion;
import org.mybatis.dynamic.sql.select.join.JoinModel;
import org.mybatis.dynamic.sql.select.join.JoinSpecification;
import org.mybatis.dynamic.sql.select.render.JoinConditionRenderer;
import org.mybatis.dynamic.sql.select.render.TableExpressionRenderer;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.FragmentCollector;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class JoinRenderer {
    private final JoinModel joinModel;
    private final TableExpressionRenderer tableExpressionRenderer;
    private final RenderingContext renderingContext;

    private JoinRenderer(Builder builder) {
        this.joinModel = Objects.requireNonNull(builder.joinModel);
        this.tableExpressionRenderer = Objects.requireNonNull(builder.tableExpressionRenderer);
        this.renderingContext = Objects.requireNonNull(builder.renderingContext);
    }

    public FragmentAndParameters render() {
        return this.joinModel.joinSpecifications().map(this::renderJoinSpecification).collect(FragmentCollector.collect()).toFragmentAndParameters(Collectors.joining(" "));
    }

    private FragmentAndParameters renderJoinSpecification(JoinSpecification joinSpecification) {
        FragmentAndParameters renderedTable = joinSpecification.table().accept(this.tableExpressionRenderer);
        FragmentAndParameters renderedJoin = this.renderConditions(joinSpecification);
        String fragment = joinSpecification.joinType().type() + StringUtilities.spaceBefore(renderedTable.fragment()) + StringUtilities.spaceBefore(renderedJoin.fragment());
        return FragmentAndParameters.withFragment(fragment).withParameters(renderedTable.parameters()).withParameters(renderedJoin.parameters()).build();
    }

    private FragmentAndParameters renderConditions(JoinSpecification joinSpecification) {
        return joinSpecification.joinCriteria().map(this::renderCriterion).collect(FragmentCollector.collect()).toFragmentAndParameters(Collectors.joining(" "));
    }

    private <T> FragmentAndParameters renderCriterion(JoinCriterion<T> joinCriterion) {
        FragmentAndParameters renderedColumn = joinCriterion.leftColumn().render(this.renderingContext);
        String prefix = joinCriterion.connector() + StringUtilities.spaceBefore(renderedColumn.fragment());
        JoinConditionRenderer joinConditionRenderer = new JoinConditionRenderer.Builder().withRenderingContext(this.renderingContext).withLeftColumn(joinCriterion.leftColumn()).build();
        FragmentAndParameters suffix = (FragmentAndParameters)joinCriterion.joinCondition().accept(joinConditionRenderer);
        return FragmentAndParameters.withFragment(prefix + StringUtilities.spaceBefore(suffix.fragment())).withParameters(suffix.parameters()).withParameters(renderedColumn.parameters()).build();
    }

    public static Builder withJoinModel(JoinModel joinModel) {
        return new Builder().withJoinModel(joinModel);
    }

    public static class Builder {
        private JoinModel joinModel;
        private TableExpressionRenderer tableExpressionRenderer;
        private RenderingContext renderingContext;

        public Builder withJoinModel(JoinModel joinModel) {
            this.joinModel = joinModel;
            return this;
        }

        public Builder withTableExpressionRenderer(TableExpressionRenderer tableExpressionRenderer) {
            this.tableExpressionRenderer = tableExpressionRenderer;
            return this;
        }

        public Builder withRenderingContext(RenderingContext renderingContext) {
            this.renderingContext = renderingContext;
            return this;
        }

        public JoinRenderer build() {
            return new JoinRenderer(this);
        }
    }
}

