/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.function;

import java.util.Objects;
import java.util.Optional;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.render.RenderingContext;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;

public class Cast
implements BasicColumn {
    private final BasicColumn column;
    private final String targetType;
    private final String alias;

    private Cast(Builder builder) {
        this.column = Objects.requireNonNull(builder.column);
        this.targetType = Objects.requireNonNull(builder.targetType);
        this.alias = builder.alias;
    }

    @Override
    public Optional<String> alias() {
        return Optional.ofNullable(this.alias);
    }

    @Override
    public Cast as(String alias) {
        return new Builder().withColumn(this.column).withTargetType(this.targetType).withAlias(alias).build();
    }

    @Override
    public FragmentAndParameters render(RenderingContext renderingContext) {
        return this.column.render(renderingContext).mapFragment(this::applyCast);
    }

    private String applyCast(String in) {
        return "cast(" + in + " as " + this.targetType + ")";
    }

    public static class Builder {
        private BasicColumn column;
        private String targetType;
        private String alias;

        public Builder withColumn(BasicColumn column) {
            this.column = column;
            return this;
        }

        public Builder withTargetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        public Builder withAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public Cast build() {
            return new Cast(this);
        }
    }
}

