/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.caseexpression;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.render.RenderingContext;
import org.mybatis.dynamic.sql.select.caseexpression.SimpleCaseWhenCondition;
import org.mybatis.dynamic.sql.select.render.SimpleCaseRenderer;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.Validator;

public class SimpleCaseModel<T>
implements BasicColumn {
    private final BindableColumn<T> column;
    private final List<SimpleCaseWhenCondition<T>> whenConditions;
    private final BasicColumn elseValue;
    private final String alias;

    private SimpleCaseModel(Builder<T> builder) {
        this.column = Objects.requireNonNull(((Builder)builder).column);
        this.whenConditions = ((Builder)builder).whenConditions;
        this.elseValue = ((Builder)builder).elseValue;
        this.alias = ((Builder)builder).alias;
        Validator.assertNotEmpty(this.whenConditions, "ERROR.40");
    }

    public BindableColumn<T> column() {
        return this.column;
    }

    public Stream<SimpleCaseWhenCondition<T>> whenConditions() {
        return this.whenConditions.stream();
    }

    public Optional<BasicColumn> elseValue() {
        return Optional.ofNullable(this.elseValue);
    }

    @Override
    public Optional<String> alias() {
        return Optional.ofNullable(this.alias);
    }

    @Override
    public SimpleCaseModel<T> as(String alias) {
        return new Builder<T>().withColumn(this.column).withWhenConditions(this.whenConditions).withElseValue(this.elseValue).withAlias(alias).build();
    }

    @Override
    public FragmentAndParameters render(RenderingContext renderingContext) {
        return new SimpleCaseRenderer(this, renderingContext).render();
    }

    public static class Builder<T> {
        private BindableColumn<T> column;
        private final List<SimpleCaseWhenCondition<T>> whenConditions = new ArrayList<SimpleCaseWhenCondition<T>>();
        private BasicColumn elseValue;
        private String alias;

        public Builder<T> withColumn(BindableColumn<T> column) {
            this.column = column;
            return this;
        }

        public Builder<T> withWhenConditions(List<SimpleCaseWhenCondition<T>> whenConditions) {
            this.whenConditions.addAll(whenConditions);
            return this;
        }

        public Builder<T> withElseValue(BasicColumn elseValue) {
            this.elseValue = elseValue;
            return this;
        }

        public Builder<T> withAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public SimpleCaseModel<T> build() {
            return new SimpleCaseModel(this);
        }
    }
}

