/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.SortSpecification;
import org.mybatis.dynamic.sql.common.OrderByModel;
import org.mybatis.dynamic.sql.configuration.StatementConfiguration;
import org.mybatis.dynamic.sql.select.PagingModel;
import org.mybatis.dynamic.sql.select.QueryExpressionDSL;
import org.mybatis.dynamic.sql.select.QueryExpressionModel;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.util.Buildable;
import org.mybatis.dynamic.sql.util.ConfigurableStatement;

public class SelectDSL<R>
implements Buildable<R>,
ConfigurableStatement<SelectDSL<R>> {
    private final Function<SelectModel, R> adapterFunction;
    private final List<QueryExpressionDSL<R>> queryExpressions = new ArrayList<QueryExpressionDSL<R>>();
    private OrderByModel orderByModel;
    private Long limit;
    private Long offset;
    private Long fetchFirstRows;
    final StatementConfiguration statementConfiguration = new StatementConfiguration();

    private SelectDSL(Function<SelectModel, R> adapterFunction) {
        this.adapterFunction = Objects.requireNonNull(adapterFunction);
    }

    public static QueryExpressionDSL.FromGatherer<SelectModel> select(BasicColumn ... selectList) {
        return SelectDSL.select(Arrays.asList(selectList));
    }

    public static QueryExpressionDSL.FromGatherer<SelectModel> select(Collection<? extends BasicColumn> selectList) {
        return SelectDSL.select(Function.identity(), selectList);
    }

    public static <R> QueryExpressionDSL.FromGatherer<R> select(Function<SelectModel, R> adapterFunction, BasicColumn ... selectList) {
        return SelectDSL.select(adapterFunction, Arrays.asList(selectList));
    }

    public static <R> QueryExpressionDSL.FromGatherer<R> select(Function<SelectModel, R> adapterFunction, Collection<? extends BasicColumn> selectList) {
        return new QueryExpressionDSL.FromGatherer.Builder().withSelectList(selectList).withSelectDSL(new SelectDSL<R>(adapterFunction)).build();
    }

    public static QueryExpressionDSL.FromGatherer<SelectModel> selectDistinct(BasicColumn ... selectList) {
        return SelectDSL.selectDistinct(Function.identity(), selectList);
    }

    public static QueryExpressionDSL.FromGatherer<SelectModel> selectDistinct(Collection<? extends BasicColumn> selectList) {
        return SelectDSL.selectDistinct(Function.identity(), selectList);
    }

    public static <R> QueryExpressionDSL.FromGatherer<R> selectDistinct(Function<SelectModel, R> adapterFunction, BasicColumn ... selectList) {
        return SelectDSL.selectDistinct(adapterFunction, Arrays.asList(selectList));
    }

    public static <R> QueryExpressionDSL.FromGatherer<R> selectDistinct(Function<SelectModel, R> adapterFunction, Collection<? extends BasicColumn> selectList) {
        return new QueryExpressionDSL.FromGatherer.Builder().withSelectList(selectList).withSelectDSL(new SelectDSL<R>(adapterFunction)).isDistinct().build();
    }

    void registerQueryExpression(QueryExpressionDSL<R> queryExpression) {
        this.queryExpressions.add(queryExpression);
    }

    void orderBy(Collection<? extends SortSpecification> columns) {
        this.orderByModel = OrderByModel.of(columns);
    }

    public LimitFinisher limit(long limit) {
        this.limit = limit;
        return new LimitFinisher();
    }

    public OffsetFirstFinisher offset(long offset) {
        this.offset = offset;
        return new OffsetFirstFinisher();
    }

    public FetchFirstFinisher fetchFirst(long fetchFirstRows) {
        this.fetchFirstRows = fetchFirstRows;
        return new FetchFirstFinisher();
    }

    @Override
    public SelectDSL<R> configureStatement(Consumer<StatementConfiguration> consumer) {
        consumer.accept(this.statementConfiguration);
        return this;
    }

    @Override
    @NotNull
    public R build() {
        SelectModel selectModel = ((SelectModel.Builder)((SelectModel.Builder)((SelectModel.Builder)SelectModel.withQueryExpressions(this.buildModels()).withOrderByModel(this.orderByModel)).withPagingModel(this.buildPagingModel().orElse(null))).withStatementConfiguration(this.statementConfiguration)).build();
        return this.adapterFunction.apply(selectModel);
    }

    private List<QueryExpressionModel> buildModels() {
        return this.queryExpressions.stream().map(QueryExpressionDSL::buildModel).collect(Collectors.toList());
    }

    private Optional<PagingModel> buildPagingModel() {
        return new PagingModel.Builder().withLimit(this.limit).withOffset(this.offset).withFetchFirstRows(this.fetchFirstRows).build();
    }

    public class LimitFinisher
    implements Buildable<R> {
        public OffsetFinisher offset(long offset) {
            SelectDSL.this.offset(offset);
            return new OffsetFinisher();
        }

        @Override
        @NotNull
        public R build() {
            return SelectDSL.this.build();
        }
    }

    public class OffsetFirstFinisher
    implements Buildable<R> {
        public FetchFirstFinisher fetchFirst(long fetchFirstRows) {
            SelectDSL.this.fetchFirst(fetchFirstRows);
            return new FetchFirstFinisher();
        }

        @Override
        @NotNull
        public R build() {
            return SelectDSL.this.build();
        }
    }

    public class FetchFirstFinisher {
        public RowsOnlyFinisher rowsOnly() {
            return new RowsOnlyFinisher();
        }
    }

    public class RowsOnlyFinisher
    implements Buildable<R> {
        @Override
        @NotNull
        public R build() {
            return SelectDSL.this.build();
        }
    }

    public class OffsetFinisher
    implements Buildable<R> {
        @Override
        @NotNull
        public R build() {
            return SelectDSL.this.build();
        }
    }
}

