/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select;

import java.util.Optional;

public class PagingModel {
    private final Long limit;
    private final Long offset;
    private final Long fetchFirstRows;

    private PagingModel(Builder builder) {
        this.limit = builder.limit;
        this.offset = builder.offset;
        this.fetchFirstRows = builder.fetchFirstRows;
    }

    public Optional<Long> limit() {
        return Optional.ofNullable(this.limit);
    }

    public Optional<Long> offset() {
        return Optional.ofNullable(this.offset);
    }

    public Optional<Long> fetchFirstRows() {
        return Optional.ofNullable(this.fetchFirstRows);
    }

    public static class Builder {
        private Long limit;
        private Long offset;
        private Long fetchFirstRows;

        public Builder withLimit(Long limit) {
            this.limit = limit;
            return this;
        }

        public Builder withOffset(Long offset) {
            this.offset = offset;
            return this;
        }

        public Builder withFetchFirstRows(Long fetchFirstRows) {
            this.fetchFirstRows = fetchFirstRows;
            return this;
        }

        public Optional<PagingModel> build() {
            if (this.limit == null && this.offset == null && this.fetchFirstRows == null) {
                return Optional.empty();
            }
            return Optional.of(new PagingModel(this));
        }
    }
}

