/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.select.AbstractSelectModel;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.select.UnionQuery;
import org.mybatis.dynamic.sql.select.render.MultiSelectRenderer;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.util.Validator;

public class MultiSelectModel
extends AbstractSelectModel {
    private final SelectModel initialSelect;
    private final List<UnionQuery> unionQueries;

    private MultiSelectModel(Builder builder) {
        super(builder);
        this.initialSelect = Objects.requireNonNull(builder.initialSelect);
        this.unionQueries = builder.unionQueries;
        Validator.assertNotEmpty(this.unionQueries, "ERROR.35");
    }

    public SelectModel initialSelect() {
        return this.initialSelect;
    }

    public Stream<UnionQuery> unionQueries() {
        return this.unionQueries.stream();
    }

    @NotNull
    public SelectStatementProvider render(RenderingStrategy renderingStrategy) {
        return new MultiSelectRenderer.Builder().withMultiSelectModel(this).withRenderingStrategy(renderingStrategy).withStatementConfiguration(this.statementConfiguration).build().render();
    }

    public static class Builder
    extends AbstractSelectModel.AbstractBuilder<Builder> {
        private SelectModel initialSelect;
        private final List<UnionQuery> unionQueries = new ArrayList<UnionQuery>();

        public Builder withInitialSelect(SelectModel initialSelect) {
            this.initialSelect = initialSelect;
            return this;
        }

        public Builder withUnionQueries(List<UnionQuery> unionQueries) {
            this.unionQueries.addAll(unionQueries);
            return this;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public MultiSelectModel build() {
            return new MultiSelectModel(this);
        }
    }
}

