/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.configuration.StatementConfiguration;
import org.mybatis.dynamic.sql.insert.GeneralInsertModel;
import org.mybatis.dynamic.sql.util.AbstractColumnMapping;
import org.mybatis.dynamic.sql.util.Buildable;
import org.mybatis.dynamic.sql.util.ConstantMapping;
import org.mybatis.dynamic.sql.util.NullMapping;
import org.mybatis.dynamic.sql.util.StringConstantMapping;
import org.mybatis.dynamic.sql.util.ValueMapping;
import org.mybatis.dynamic.sql.util.ValueOrNullMapping;
import org.mybatis.dynamic.sql.util.ValueWhenPresentMapping;

public class GeneralInsertDSL
implements Buildable<GeneralInsertModel> {
    private final List<AbstractColumnMapping> columnMappings;
    private final SqlTable table;

    private GeneralInsertDSL(Builder builder) {
        this.table = Objects.requireNonNull(builder.table);
        this.columnMappings = builder.columnMappings;
    }

    public <T> SetClauseFinisher<T> set(SqlColumn<T> column) {
        return new SetClauseFinisher<T>(column);
    }

    @Override
    @NotNull
    public GeneralInsertModel build() {
        return new GeneralInsertModel.Builder().withTable(this.table).withInsertMappings(this.columnMappings).withStatementConfiguration(new StatementConfiguration()).build();
    }

    public static GeneralInsertDSL insertInto(SqlTable table) {
        return new Builder().withTable(table).build();
    }

    public static class Builder {
        private final List<AbstractColumnMapping> columnMappings = new ArrayList<AbstractColumnMapping>();
        private SqlTable table;

        public Builder withTable(SqlTable table) {
            this.table = table;
            return this;
        }

        public Builder withColumnMappings(Collection<? extends AbstractColumnMapping> columnMappings) {
            this.columnMappings.addAll(columnMappings);
            return this;
        }

        public GeneralInsertDSL build() {
            return new GeneralInsertDSL(this);
        }
    }

    public class SetClauseFinisher<T> {
        private final SqlColumn<T> column;

        public SetClauseFinisher(SqlColumn<T> column) {
            this.column = column;
        }

        public GeneralInsertDSL toNull() {
            GeneralInsertDSL.this.columnMappings.add(NullMapping.of(this.column));
            return GeneralInsertDSL.this;
        }

        public GeneralInsertDSL toConstant(String constant) {
            GeneralInsertDSL.this.columnMappings.add(ConstantMapping.of(this.column, constant));
            return GeneralInsertDSL.this;
        }

        public GeneralInsertDSL toStringConstant(String constant) {
            GeneralInsertDSL.this.columnMappings.add(StringConstantMapping.of(this.column, constant));
            return GeneralInsertDSL.this;
        }

        public GeneralInsertDSL toValue(T value) {
            return this.toValue(() -> value);
        }

        public GeneralInsertDSL toValue(Supplier<T> valueSupplier) {
            GeneralInsertDSL.this.columnMappings.add(ValueMapping.of(this.column, valueSupplier));
            return GeneralInsertDSL.this;
        }

        public GeneralInsertDSL toValueOrNull(T value) {
            return this.toValueOrNull(() -> value);
        }

        public GeneralInsertDSL toValueOrNull(Supplier<T> valueSupplier) {
            GeneralInsertDSL.this.columnMappings.add(ValueOrNullMapping.of(this.column, valueSupplier));
            return GeneralInsertDSL.this;
        }

        public GeneralInsertDSL toValueWhenPresent(T value) {
            return this.toValueWhenPresent(() -> value);
        }

        public GeneralInsertDSL toValueWhenPresent(Supplier<T> valueSupplier) {
            GeneralInsertDSL.this.columnMappings.add(ValueWhenPresentMapping.of(this.column, valueSupplier));
            return GeneralInsertDSL.this;
        }
    }
}

