/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.mybatis.dynamic.sql.exception.DynamicSqlException;
import org.mybatis.dynamic.sql.util.Messages;

public class GlobalConfiguration {
    public static final String CONFIGURATION_FILE_PROPERTY = "mybatis-dynamic-sql.configurationFile";
    private static final String DEFAULT_PROPERTY_FILE = "mybatis-dynamic-sql.properties";
    private boolean isNonRenderingWhereClauseAllowed = false;
    private final Properties properties = new Properties();

    public GlobalConfiguration() {
        this.initialize();
    }

    private void initialize() {
        this.initializeProperties();
        this.initializeKnownProperties();
    }

    private void initializeProperties() {
        String configFileName = this.getConfigurationFileName();
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(configFileName);
        if (inputStream != null) {
            this.loadProperties(inputStream, configFileName);
        }
    }

    private String getConfigurationFileName() {
        String property = System.getProperty(CONFIGURATION_FILE_PROPERTY);
        if (property == null) {
            return DEFAULT_PROPERTY_FILE;
        }
        return property;
    }

    void loadProperties(InputStream inputStream, String propertyFile) {
        try {
            this.properties.load(inputStream);
        }
        catch (IOException e) {
            throw new DynamicSqlException(Messages.getString("ERROR.3", propertyFile), e);
        }
    }

    private void initializeKnownProperties() {
        String value = this.properties.getProperty("nonRenderingWhereClauseAllowed", "false");
        this.isNonRenderingWhereClauseAllowed = Boolean.parseBoolean(value);
    }

    public boolean isIsNonRenderingWhereClauseAllowed() {
        return this.isNonRenderingWhereClauseAllowed;
    }
}

