/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mybatis.dynamic.sql.AndOrCriteriaGroup;
import org.mybatis.dynamic.sql.SqlCriterion;

public abstract class AbstractBooleanExpressionModel {
    private final SqlCriterion initialCriterion;
    private final List<AndOrCriteriaGroup> subCriteria;

    protected AbstractBooleanExpressionModel(AbstractBuilder<?> builder) {
        this.initialCriterion = ((AbstractBuilder)builder).initialCriterion;
        this.subCriteria = ((AbstractBuilder)builder).subCriteria;
    }

    public Optional<SqlCriterion> initialCriterion() {
        return Optional.ofNullable(this.initialCriterion);
    }

    public List<AndOrCriteriaGroup> subCriteria() {
        return Collections.unmodifiableList(this.subCriteria);
    }

    public static abstract class AbstractBuilder<T extends AbstractBuilder<T>> {
        private SqlCriterion initialCriterion;
        private final List<AndOrCriteriaGroup> subCriteria = new ArrayList<AndOrCriteriaGroup>();

        public T withInitialCriterion(SqlCriterion initialCriterion) {
            this.initialCriterion = initialCriterion;
            return this.getThis();
        }

        public T withSubCriteria(List<AndOrCriteriaGroup> subCriteria) {
            this.subCriteria.addAll(subCriteria);
            return this.getThis();
        }

        protected abstract T getThis();
    }
}

