/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql;

import java.util.Objects;
import java.util.Optional;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.exception.InvalidSqlException;
import org.mybatis.dynamic.sql.render.RenderedParameterInfo;
import org.mybatis.dynamic.sql.render.RenderingContext;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.Messages;

public class BoundValue<T>
implements BindableColumn<T> {
    private final T value;

    private BoundValue(T value) {
        this.value = Objects.requireNonNull(value);
    }

    @Override
    public FragmentAndParameters render(RenderingContext renderingContext) {
        RenderedParameterInfo rpi = renderingContext.calculateParameterInfo(this);
        return FragmentAndParameters.withFragment(rpi.renderedPlaceHolder()).withParameter(rpi.parameterMapKey(), this.value).build();
    }

    @Override
    public Optional<String> alias() {
        return Optional.empty();
    }

    @Override
    public BoundValue<T> as(String alias) {
        throw new InvalidSqlException(Messages.getString("ERROR.38"));
    }

    public static <T> BoundValue<T> of(T value) {
        return new BoundValue<T>(value);
    }
}

