/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.client.gridfs;

import com.mongodb.MongoGridFSException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.gridfs.model.GridFSDownloadOptions;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.client.AsyncClientSession;
import com.mongodb.internal.async.client.AsyncFindIterable;
import com.mongodb.internal.async.client.AsyncMongoClients;
import com.mongodb.internal.async.client.AsyncMongoCollection;
import com.mongodb.internal.async.client.AsyncMongoDatabase;
import com.mongodb.internal.async.client.gridfs.AsyncGridFSBucket;
import com.mongodb.internal.async.client.gridfs.AsyncGridFSDownloadStream;
import com.mongodb.internal.async.client.gridfs.AsyncGridFSDownloadStreamImpl;
import com.mongodb.internal.async.client.gridfs.AsyncGridFSFindIterable;
import com.mongodb.internal.async.client.gridfs.AsyncGridFSFindIterableImpl;
import com.mongodb.internal.async.client.gridfs.AsyncGridFSUploadStream;
import com.mongodb.internal.async.client.gridfs.AsyncGridFSUploadStreamImpl;
import com.mongodb.internal.async.client.gridfs.GridFSIndexCheckImpl;
import com.mongodb.lang.Nullable;
import org.bson.BsonDocument;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

final class AsyncGridFSBucketImpl
implements AsyncGridFSBucket {
    private static final Logger LOGGER = Loggers.getLogger("client.gridfs");
    private static final int DEFAULT_CHUNKSIZE_BYTES = 261120;
    private final String bucketName;
    private final int chunkSizeBytes;
    private final AsyncMongoCollection<GridFSFile> filesCollection;
    private final AsyncMongoCollection<Document> chunksCollection;

    AsyncGridFSBucketImpl(AsyncMongoDatabase database) {
        this(database, "fs");
    }

    AsyncGridFSBucketImpl(AsyncMongoDatabase database, String bucketName) {
        this(Assertions.notNull("bucketName", bucketName), 261120, AsyncGridFSBucketImpl.getFilesCollection(Assertions.notNull("database", database), bucketName), AsyncGridFSBucketImpl.getChunksCollection(database, bucketName));
    }

    AsyncGridFSBucketImpl(String bucketName, int chunkSizeBytes, AsyncMongoCollection<GridFSFile> filesCollection, AsyncMongoCollection<Document> chunksCollection) {
        this.bucketName = Assertions.notNull("bucketName", bucketName);
        this.chunkSizeBytes = chunkSizeBytes;
        this.filesCollection = Assertions.notNull("filesCollection", filesCollection);
        this.chunksCollection = Assertions.notNull("chunksCollection", chunksCollection);
    }

    @Override
    public String getBucketName() {
        return this.bucketName;
    }

    @Override
    public int getChunkSizeBytes() {
        return this.chunkSizeBytes;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.filesCollection.getReadPreference();
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.filesCollection.getWriteConcern();
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.filesCollection.getReadConcern();
    }

    @Override
    public AsyncGridFSBucket withChunkSizeBytes(int chunkSizeBytes) {
        return new AsyncGridFSBucketImpl(this.bucketName, chunkSizeBytes, this.filesCollection, this.chunksCollection);
    }

    @Override
    public AsyncGridFSBucket withReadPreference(ReadPreference readPreference) {
        Assertions.notNull("readPreference", readPreference);
        return new AsyncGridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withReadPreference(readPreference), this.chunksCollection.withReadPreference(readPreference));
    }

    @Override
    public AsyncGridFSBucket withWriteConcern(WriteConcern writeConcern) {
        Assertions.notNull("writeConcern", writeConcern);
        return new AsyncGridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withWriteConcern(writeConcern), this.chunksCollection.withWriteConcern(writeConcern));
    }

    @Override
    public AsyncGridFSBucket withReadConcern(ReadConcern readConcern) {
        Assertions.notNull("readConcern", readConcern);
        return new AsyncGridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withReadConcern(readConcern), this.chunksCollection.withReadConcern(readConcern));
    }

    @Override
    public AsyncGridFSUploadStream openUploadStream(String filename) {
        return this.openUploadStream((BsonValue)new BsonObjectId(), filename);
    }

    @Override
    public AsyncGridFSUploadStream openUploadStream(String filename, GridFSUploadOptions options) {
        return this.openUploadStream((BsonValue)new BsonObjectId(), filename, options);
    }

    @Override
    public AsyncGridFSUploadStream openUploadStream(BsonValue id, String filename) {
        return this.openUploadStream(id, filename, new GridFSUploadOptions());
    }

    @Override
    public AsyncGridFSUploadStream openUploadStream(BsonValue id, String filename, GridFSUploadOptions options) {
        return this.createGridFSUploadStream(null, id, filename, options);
    }

    @Override
    public AsyncGridFSUploadStream openUploadStream(AsyncClientSession clientSession, String filename) {
        return this.openUploadStream(clientSession, (BsonValue)new BsonObjectId(), filename);
    }

    @Override
    public AsyncGridFSUploadStream openUploadStream(AsyncClientSession clientSession, String filename, GridFSUploadOptions options) {
        return this.openUploadStream(clientSession, (BsonValue)new BsonObjectId(), filename, options);
    }

    @Override
    public AsyncGridFSUploadStream openUploadStream(AsyncClientSession clientSession, BsonValue id, String filename) {
        return this.openUploadStream(clientSession, id, filename, new GridFSUploadOptions());
    }

    @Override
    public AsyncGridFSUploadStream openUploadStream(AsyncClientSession clientSession, BsonValue id, String filename, GridFSUploadOptions options) {
        Assertions.notNull("clientSession", clientSession);
        return this.createGridFSUploadStream(clientSession, id, filename, options);
    }

    private AsyncGridFSUploadStream createGridFSUploadStream(@Nullable AsyncClientSession clientSession, BsonValue id, String filename, GridFSUploadOptions options) {
        Assertions.notNull("options", options);
        Integer chunkSizeBytes = options.getChunkSizeBytes();
        int chunkSize = chunkSizeBytes == null ? this.chunkSizeBytes : chunkSizeBytes;
        return new AsyncGridFSUploadStreamImpl(clientSession, this.filesCollection, this.chunksCollection, id, filename, chunkSize, options.getMetadata(), new GridFSIndexCheckImpl(clientSession, this.filesCollection, this.chunksCollection));
    }

    @Override
    public AsyncGridFSDownloadStream openDownloadStream(ObjectId id) {
        Assertions.notNull("id", id);
        return this.createGridFSDownloadStream(null, this.find((Bson)new Document("_id", (Object)id)));
    }

    @Override
    public AsyncGridFSDownloadStream openDownloadStream(BsonValue id) {
        Assertions.notNull("id", id);
        return this.createGridFSDownloadStream(null, this.find((Bson)new Document("_id", (Object)id)));
    }

    @Override
    public AsyncGridFSDownloadStream openDownloadStream(String filename) {
        return this.openDownloadStream(filename, new GridFSDownloadOptions());
    }

    @Override
    public AsyncGridFSDownloadStream openDownloadStream(String filename, GridFSDownloadOptions options) {
        return this.createGridFSDownloadStream(null, this.createGridFSFindIterable(null, filename, options));
    }

    @Override
    public AsyncGridFSDownloadStream openDownloadStream(AsyncClientSession clientSession, ObjectId id) {
        Assertions.notNull("id", id);
        return this.createGridFSDownloadStream(clientSession, this.find(clientSession, (Bson)new Document("_id", (Object)id)));
    }

    @Override
    public AsyncGridFSDownloadStream openDownloadStream(AsyncClientSession clientSession, BsonValue id) {
        Assertions.notNull("id", id);
        return this.createGridFSDownloadStream(clientSession, this.find(clientSession, (Bson)new Document("_id", (Object)id)));
    }

    @Override
    public AsyncGridFSDownloadStream openDownloadStream(AsyncClientSession clientSession, String filename) {
        return this.openDownloadStream(clientSession, filename, new GridFSDownloadOptions());
    }

    @Override
    public AsyncGridFSDownloadStream openDownloadStream(AsyncClientSession clientSession, String filename, GridFSDownloadOptions options) {
        Assertions.notNull("clientSession", clientSession);
        return this.createGridFSDownloadStream(clientSession, this.createGridFSFindIterable(clientSession, filename, options));
    }

    private AsyncGridFSDownloadStream createGridFSDownloadStream(@Nullable AsyncClientSession clientSession, AsyncGridFSFindIterable gridFSFindIterable) {
        return new AsyncGridFSDownloadStreamImpl(clientSession, gridFSFindIterable, this.chunksCollection);
    }

    @Override
    public AsyncGridFSFindIterable find() {
        return this.createGridFSFindIterable(null, null);
    }

    @Override
    public AsyncGridFSFindIterable find(Bson filter) {
        Assertions.notNull("filter", filter);
        return this.createGridFSFindIterable(null, filter);
    }

    @Override
    public AsyncGridFSFindIterable find(AsyncClientSession clientSession) {
        Assertions.notNull("clientSession", clientSession);
        return this.createGridFSFindIterable(clientSession, null);
    }

    @Override
    public AsyncGridFSFindIterable find(AsyncClientSession clientSession, Bson filter) {
        Assertions.notNull("clientSession", clientSession);
        Assertions.notNull("filter", filter);
        return this.createGridFSFindIterable(clientSession, filter);
    }

    @Override
    public void delete(ObjectId id, SingleResultCallback<Void> callback) {
        this.delete((BsonValue)new BsonObjectId(id), callback);
    }

    @Override
    public void delete(BsonValue id, SingleResultCallback<Void> callback) {
        this.executeDelete(null, id, callback);
    }

    @Override
    public void delete(AsyncClientSession clientSession, ObjectId id, SingleResultCallback<Void> callback) {
        this.delete(clientSession, (BsonValue)new BsonObjectId(id), callback);
    }

    @Override
    public void delete(AsyncClientSession clientSession, BsonValue id, SingleResultCallback<Void> callback) {
        Assertions.notNull("clientSession", clientSession);
        this.executeDelete(clientSession, id, callback);
    }

    private void executeDelete(@Nullable AsyncClientSession clientSession, BsonValue id, SingleResultCallback<Void> callback) {
        Assertions.notNull("id", id);
        Assertions.notNull("callback", callback);
        SingleResultCallback<Void> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, LOGGER);
        SingleResultCallback<DeleteResult> deleteFileCallback = (filesResult, t) -> {
            if (t != null) {
                errHandlingCallback.onResult(null, t);
            } else {
                SingleResultCallback<DeleteResult> deleteChunksCallback = (chunksResult, t1) -> {
                    if (t1 != null) {
                        errHandlingCallback.onResult(null, t1);
                    } else if (filesResult.wasAcknowledged() && filesResult.getDeletedCount() == 0L) {
                        errHandlingCallback.onResult(null, new MongoGridFSException(String.format("No file found with the ObjectId: %s", id)));
                    } else {
                        errHandlingCallback.onResult(null, null);
                    }
                };
                if (clientSession != null) {
                    this.chunksCollection.deleteMany(clientSession, (Bson)new BsonDocument("files_id", id), deleteChunksCallback);
                } else {
                    this.chunksCollection.deleteMany((Bson)new BsonDocument("files_id", id), deleteChunksCallback);
                }
            }
        };
        if (clientSession != null) {
            this.filesCollection.deleteOne(clientSession, (Bson)new BsonDocument("_id", id), deleteFileCallback);
        } else {
            this.filesCollection.deleteOne((Bson)new BsonDocument("_id", id), deleteFileCallback);
        }
    }

    @Override
    public void rename(ObjectId id, String newFilename, SingleResultCallback<Void> callback) {
        this.rename((BsonValue)new BsonObjectId(id), newFilename, callback);
    }

    @Override
    public void rename(BsonValue id, String newFilename, SingleResultCallback<Void> callback) {
        this.executeRename(null, id, newFilename, callback);
    }

    @Override
    public void rename(AsyncClientSession clientSession, ObjectId id, String newFilename, SingleResultCallback<Void> callback) {
        this.rename(clientSession, (BsonValue)new BsonObjectId(id), newFilename, callback);
    }

    @Override
    public void rename(AsyncClientSession clientSession, BsonValue id, String newFilename, SingleResultCallback<Void> callback) {
        Assertions.notNull("clientSession", clientSession);
        this.executeRename(clientSession, id, newFilename, callback);
    }

    private void executeRename(@Nullable AsyncClientSession clientSession, BsonValue id, String newFilename, SingleResultCallback<Void> callback) {
        Assertions.notNull("id", id);
        Assertions.notNull("newFilename", newFilename);
        Assertions.notNull("callback", callback);
        SingleResultCallback<Void> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, LOGGER);
        SingleResultCallback<UpdateResult> resultCallback = (result, t) -> {
            if (t != null) {
                errHandlingCallback.onResult(null, t);
            } else if (result.wasAcknowledged() && result.getMatchedCount() == 0L) {
                errHandlingCallback.onResult(null, new MongoGridFSException(String.format("No file found with the ObjectId: %s", id)));
            } else {
                errHandlingCallback.onResult(null, null);
            }
        };
        if (clientSession != null) {
            this.filesCollection.updateOne(clientSession, (Bson)new BsonDocument("_id", id), (Bson)new BsonDocument("$set", (BsonValue)new BsonDocument("filename", (BsonValue)new BsonString(newFilename))), resultCallback);
        } else {
            this.filesCollection.updateOne((Bson)new BsonDocument("_id", id), (Bson)new BsonDocument("$set", (BsonValue)new BsonDocument("filename", (BsonValue)new BsonString(newFilename))), resultCallback);
        }
    }

    @Override
    public void drop(SingleResultCallback<Void> callback) {
        this.executeDrop(null, callback);
    }

    @Override
    public void drop(AsyncClientSession clientSession, SingleResultCallback<Void> callback) {
        Assertions.notNull("clientSession", clientSession);
        this.executeDrop(clientSession, callback);
    }

    private void executeDrop(@Nullable AsyncClientSession clientSession, SingleResultCallback<Void> callback) {
        Assertions.notNull("callback", callback);
        SingleResultCallback<Void> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, LOGGER);
        SingleResultCallback<Void> dropFileCallback = (result, t) -> {
            if (t != null) {
                errHandlingCallback.onResult(null, t);
            } else if (clientSession != null) {
                this.chunksCollection.drop(clientSession, errHandlingCallback);
            } else {
                this.chunksCollection.drop(errHandlingCallback);
            }
        };
        if (clientSession != null) {
            this.filesCollection.drop(clientSession, dropFileCallback);
        } else {
            this.filesCollection.drop(dropFileCallback);
        }
    }

    private AsyncGridFSFindIterable createGridFSFindIterable(@Nullable AsyncClientSession clientSession, @Nullable Bson filter) {
        return new AsyncGridFSFindIterableImpl(this.createFindIterable(clientSession, filter));
    }

    private AsyncGridFSFindIterable createGridFSFindIterable(@Nullable AsyncClientSession clientSession, String filename, GridFSDownloadOptions options) {
        int sort;
        int skip;
        int revision = options.getRevision();
        if (revision >= 0) {
            skip = revision;
            sort = 1;
        } else {
            skip = -revision - 1;
            sort = -1;
        }
        return this.createGridFSFindIterable(clientSession, (Bson)new Document("filename", (Object)filename)).skip(skip).sort((Bson)new Document("uploadDate", (Object)sort));
    }

    private AsyncFindIterable<GridFSFile> createFindIterable(@Nullable AsyncClientSession clientSession, @Nullable Bson filter) {
        AsyncFindIterable<GridFSFile> findIterable = clientSession != null ? this.filesCollection.find(clientSession) : this.filesCollection.find();
        if (filter != null) {
            findIterable = findIterable.filter(filter);
        }
        return findIterable;
    }

    private static AsyncMongoCollection<GridFSFile> getFilesCollection(AsyncMongoDatabase database, String bucketName) {
        return database.getCollection(bucketName + ".files", GridFSFile.class).withCodecRegistry(CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{database.getCodecRegistry(), AsyncMongoClients.getDefaultCodecRegistry()}));
    }

    private static AsyncMongoCollection<Document> getChunksCollection(AsyncMongoDatabase database, String bucketName) {
        return database.getCollection(bucketName + ".chunks").withCodecRegistry(AsyncMongoClients.getDefaultCodecRegistry());
    }
}

