/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkTransformMatrixKHR
extends Struct<VkTransformMatrixKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MATRIX;

    protected VkTransformMatrixKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkTransformMatrixKHR create(long address, @Nullable ByteBuffer container) {
        return new VkTransformMatrixKHR(address, container);
    }

    public VkTransformMatrixKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkTransformMatrixKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float[3][4]")
    public FloatBuffer matrix() {
        return VkTransformMatrixKHR.nmatrix(this.address());
    }

    public float matrix(int index) {
        return VkTransformMatrixKHR.nmatrix(this.address(), index);
    }

    public VkTransformMatrixKHR matrix(@NativeType(value="float[3][4]") FloatBuffer value) {
        VkTransformMatrixKHR.nmatrix(this.address(), value);
        return this;
    }

    public VkTransformMatrixKHR matrix(int index, float value) {
        VkTransformMatrixKHR.nmatrix(this.address(), index, value);
        return this;
    }

    public VkTransformMatrixKHR set(VkTransformMatrixKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkTransformMatrixKHR malloc() {
        return new VkTransformMatrixKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkTransformMatrixKHR calloc() {
        return new VkTransformMatrixKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkTransformMatrixKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkTransformMatrixKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkTransformMatrixKHR create(long address) {
        return new VkTransformMatrixKHR(address, null);
    }

    @Nullable
    public static VkTransformMatrixKHR createSafe(long address) {
        return address == 0L ? null : new VkTransformMatrixKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkTransformMatrixKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkTransformMatrixKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkTransformMatrixKHR malloc(MemoryStack stack) {
        return new VkTransformMatrixKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkTransformMatrixKHR calloc(MemoryStack stack) {
        return new VkTransformMatrixKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static FloatBuffer nmatrix(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)MATRIX), (int)12);
    }

    public static float nmatrix(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)MATRIX + Checks.check((int)index, (int)12) * 4L);
    }

    public static void nmatrix(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)12);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((FloatBuffer)value), (long)(struct + (long)MATRIX), (long)(value.remaining() * 4));
    }

    public static void nmatrix(long struct, int index, float value) {
        UNSAFE.putFloat(null, struct + (long)MATRIX + Checks.check((int)index, (int)12) * 4L, value);
    }

    static {
        Struct.Layout layout = VkTransformMatrixKHR.__struct((Struct.Member[])new Struct.Member[]{VkTransformMatrixKHR.__array((int)4, (int)12)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MATRIX = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<VkTransformMatrixKHR, Buffer>
    implements NativeResource {
        private static final VkTransformMatrixKHR ELEMENT_FACTORY = VkTransformMatrixKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkTransformMatrixKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="float[3][4]")
        public FloatBuffer matrix() {
            return VkTransformMatrixKHR.nmatrix(this.address());
        }

        public float matrix(int index) {
            return VkTransformMatrixKHR.nmatrix(this.address(), index);
        }

        public Buffer matrix(@NativeType(value="float[3][4]") FloatBuffer value) {
            VkTransformMatrixKHR.nmatrix(this.address(), value);
            return this;
        }

        public Buffer matrix(int index, float value) {
            VkTransformMatrixKHR.nmatrix(this.address(), index, value);
            return this;
        }
    }
}

