/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent3D;
import org.lwjgl.vulkan.VkImageSubresourceLayers;
import org.lwjgl.vulkan.VkOffset3D;

public class VkMemoryToImageCopyEXT
extends Struct<VkMemoryToImageCopyEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PHOSTPOINTER;
    public static final int MEMORYROWLENGTH;
    public static final int MEMORYIMAGEHEIGHT;
    public static final int IMAGESUBRESOURCE;
    public static final int IMAGEOFFSET;
    public static final int IMAGEEXTENT;

    protected VkMemoryToImageCopyEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkMemoryToImageCopyEXT create(long address, @Nullable ByteBuffer container) {
        return new VkMemoryToImageCopyEXT(address, container);
    }

    public VkMemoryToImageCopyEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkMemoryToImageCopyEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryToImageCopyEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMemoryToImageCopyEXT.npNext(this.address());
    }

    @NativeType(value="void const *")
    public long pHostPointer() {
        return VkMemoryToImageCopyEXT.npHostPointer(this.address());
    }

    @NativeType(value="uint32_t")
    public int memoryRowLength() {
        return VkMemoryToImageCopyEXT.nmemoryRowLength(this.address());
    }

    @NativeType(value="uint32_t")
    public int memoryImageHeight() {
        return VkMemoryToImageCopyEXT.nmemoryImageHeight(this.address());
    }

    public VkImageSubresourceLayers imageSubresource() {
        return VkMemoryToImageCopyEXT.nimageSubresource(this.address());
    }

    public VkOffset3D imageOffset() {
        return VkMemoryToImageCopyEXT.nimageOffset(this.address());
    }

    public VkExtent3D imageExtent() {
        return VkMemoryToImageCopyEXT.nimageExtent(this.address());
    }

    public VkMemoryToImageCopyEXT sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryToImageCopyEXT.nsType(this.address(), value);
        return this;
    }

    public VkMemoryToImageCopyEXT sType$Default() {
        return this.sType(1000270002);
    }

    public VkMemoryToImageCopyEXT pNext(@NativeType(value="void const *") long value) {
        VkMemoryToImageCopyEXT.npNext(this.address(), value);
        return this;
    }

    public VkMemoryToImageCopyEXT pHostPointer(@NativeType(value="void const *") long value) {
        VkMemoryToImageCopyEXT.npHostPointer(this.address(), value);
        return this;
    }

    public VkMemoryToImageCopyEXT memoryRowLength(@NativeType(value="uint32_t") int value) {
        VkMemoryToImageCopyEXT.nmemoryRowLength(this.address(), value);
        return this;
    }

    public VkMemoryToImageCopyEXT memoryImageHeight(@NativeType(value="uint32_t") int value) {
        VkMemoryToImageCopyEXT.nmemoryImageHeight(this.address(), value);
        return this;
    }

    public VkMemoryToImageCopyEXT imageSubresource(VkImageSubresourceLayers value) {
        VkMemoryToImageCopyEXT.nimageSubresource(this.address(), value);
        return this;
    }

    public VkMemoryToImageCopyEXT imageSubresource(Consumer<VkImageSubresourceLayers> consumer) {
        consumer.accept(this.imageSubresource());
        return this;
    }

    public VkMemoryToImageCopyEXT imageOffset(VkOffset3D value) {
        VkMemoryToImageCopyEXT.nimageOffset(this.address(), value);
        return this;
    }

    public VkMemoryToImageCopyEXT imageOffset(Consumer<VkOffset3D> consumer) {
        consumer.accept(this.imageOffset());
        return this;
    }

    public VkMemoryToImageCopyEXT imageExtent(VkExtent3D value) {
        VkMemoryToImageCopyEXT.nimageExtent(this.address(), value);
        return this;
    }

    public VkMemoryToImageCopyEXT imageExtent(Consumer<VkExtent3D> consumer) {
        consumer.accept(this.imageExtent());
        return this;
    }

    public VkMemoryToImageCopyEXT set(int sType, long pNext, long pHostPointer, int memoryRowLength, int memoryImageHeight, VkImageSubresourceLayers imageSubresource, VkOffset3D imageOffset, VkExtent3D imageExtent) {
        this.sType(sType);
        this.pNext(pNext);
        this.pHostPointer(pHostPointer);
        this.memoryRowLength(memoryRowLength);
        this.memoryImageHeight(memoryImageHeight);
        this.imageSubresource(imageSubresource);
        this.imageOffset(imageOffset);
        this.imageExtent(imageExtent);
        return this;
    }

    public VkMemoryToImageCopyEXT set(VkMemoryToImageCopyEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkMemoryToImageCopyEXT malloc() {
        return new VkMemoryToImageCopyEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkMemoryToImageCopyEXT calloc() {
        return new VkMemoryToImageCopyEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkMemoryToImageCopyEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkMemoryToImageCopyEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkMemoryToImageCopyEXT create(long address) {
        return new VkMemoryToImageCopyEXT(address, null);
    }

    @Nullable
    public static VkMemoryToImageCopyEXT createSafe(long address) {
        return address == 0L ? null : new VkMemoryToImageCopyEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkMemoryToImageCopyEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryToImageCopyEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkMemoryToImageCopyEXT malloc(MemoryStack stack) {
        return new VkMemoryToImageCopyEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMemoryToImageCopyEXT calloc(MemoryStack stack) {
        return new VkMemoryToImageCopyEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long npHostPointer(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PHOSTPOINTER));
    }

    public static int nmemoryRowLength(long struct) {
        return UNSAFE.getInt(null, struct + (long)MEMORYROWLENGTH);
    }

    public static int nmemoryImageHeight(long struct) {
        return UNSAFE.getInt(null, struct + (long)MEMORYIMAGEHEIGHT);
    }

    public static VkImageSubresourceLayers nimageSubresource(long struct) {
        return VkImageSubresourceLayers.create(struct + (long)IMAGESUBRESOURCE);
    }

    public static VkOffset3D nimageOffset(long struct) {
        return VkOffset3D.create(struct + (long)IMAGEOFFSET);
    }

    public static VkExtent3D nimageExtent(long struct) {
        return VkExtent3D.create(struct + (long)IMAGEEXTENT);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void npHostPointer(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PHOSTPOINTER), (long)Checks.check((long)value));
    }

    public static void nmemoryRowLength(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MEMORYROWLENGTH, value);
    }

    public static void nmemoryImageHeight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MEMORYIMAGEHEIGHT, value);
    }

    public static void nimageSubresource(long struct, VkImageSubresourceLayers value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)IMAGESUBRESOURCE), (long)VkImageSubresourceLayers.SIZEOF);
    }

    public static void nimageOffset(long struct, VkOffset3D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)IMAGEOFFSET), (long)VkOffset3D.SIZEOF);
    }

    public static void nimageExtent(long struct, VkExtent3D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)IMAGEEXTENT), (long)VkExtent3D.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PHOSTPOINTER)));
    }

    static {
        Struct.Layout layout = VkMemoryToImageCopyEXT.__struct((Struct.Member[])new Struct.Member[]{VkMemoryToImageCopyEXT.__member((int)4), VkMemoryToImageCopyEXT.__member((int)POINTER_SIZE), VkMemoryToImageCopyEXT.__member((int)POINTER_SIZE), VkMemoryToImageCopyEXT.__member((int)4), VkMemoryToImageCopyEXT.__member((int)4), VkMemoryToImageCopyEXT.__member((int)VkImageSubresourceLayers.SIZEOF, (int)VkImageSubresourceLayers.ALIGNOF), VkMemoryToImageCopyEXT.__member((int)VkOffset3D.SIZEOF, (int)VkOffset3D.ALIGNOF), VkMemoryToImageCopyEXT.__member((int)VkExtent3D.SIZEOF, (int)VkExtent3D.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PHOSTPOINTER = layout.offsetof(2);
        MEMORYROWLENGTH = layout.offsetof(3);
        MEMORYIMAGEHEIGHT = layout.offsetof(4);
        IMAGESUBRESOURCE = layout.offsetof(5);
        IMAGEOFFSET = layout.offsetof(6);
        IMAGEEXTENT = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryToImageCopyEXT, Buffer>
    implements NativeResource {
        private static final VkMemoryToImageCopyEXT ELEMENT_FACTORY = VkMemoryToImageCopyEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkMemoryToImageCopyEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryToImageCopyEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMemoryToImageCopyEXT.npNext(this.address());
        }

        @NativeType(value="void const *")
        public long pHostPointer() {
            return VkMemoryToImageCopyEXT.npHostPointer(this.address());
        }

        @NativeType(value="uint32_t")
        public int memoryRowLength() {
            return VkMemoryToImageCopyEXT.nmemoryRowLength(this.address());
        }

        @NativeType(value="uint32_t")
        public int memoryImageHeight() {
            return VkMemoryToImageCopyEXT.nmemoryImageHeight(this.address());
        }

        public VkImageSubresourceLayers imageSubresource() {
            return VkMemoryToImageCopyEXT.nimageSubresource(this.address());
        }

        public VkOffset3D imageOffset() {
            return VkMemoryToImageCopyEXT.nimageOffset(this.address());
        }

        public VkExtent3D imageExtent() {
            return VkMemoryToImageCopyEXT.nimageExtent(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryToImageCopyEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000270002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryToImageCopyEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer pHostPointer(@NativeType(value="void const *") long value) {
            VkMemoryToImageCopyEXT.npHostPointer(this.address(), value);
            return this;
        }

        public Buffer memoryRowLength(@NativeType(value="uint32_t") int value) {
            VkMemoryToImageCopyEXT.nmemoryRowLength(this.address(), value);
            return this;
        }

        public Buffer memoryImageHeight(@NativeType(value="uint32_t") int value) {
            VkMemoryToImageCopyEXT.nmemoryImageHeight(this.address(), value);
            return this;
        }

        public Buffer imageSubresource(VkImageSubresourceLayers value) {
            VkMemoryToImageCopyEXT.nimageSubresource(this.address(), value);
            return this;
        }

        public Buffer imageSubresource(Consumer<VkImageSubresourceLayers> consumer) {
            consumer.accept(this.imageSubresource());
            return this;
        }

        public Buffer imageOffset(VkOffset3D value) {
            VkMemoryToImageCopyEXT.nimageOffset(this.address(), value);
            return this;
        }

        public Buffer imageOffset(Consumer<VkOffset3D> consumer) {
            consumer.accept(this.imageOffset());
            return this;
        }

        public Buffer imageExtent(VkExtent3D value) {
            VkMemoryToImageCopyEXT.nimageExtent(this.address(), value);
            return this;
        }

        public Buffer imageExtent(Consumer<VkExtent3D> consumer) {
            consumer.accept(this.imageExtent());
            return this;
        }
    }
}

