/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkMemoryDedicatedRequirements;
import org.lwjgl.vulkan.VkMemoryDedicatedRequirementsKHR;
import org.lwjgl.vulkan.VkMemoryRequirements;

public class VkMemoryRequirements2
extends Struct<VkMemoryRequirements2>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MEMORYREQUIREMENTS;

    protected VkMemoryRequirements2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkMemoryRequirements2 create(long address, @Nullable ByteBuffer container) {
        return new VkMemoryRequirements2(address, container);
    }

    public VkMemoryRequirements2(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkMemoryRequirements2.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryRequirements2.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkMemoryRequirements2.npNext(this.address());
    }

    public VkMemoryRequirements memoryRequirements() {
        return VkMemoryRequirements2.nmemoryRequirements(this.address());
    }

    public VkMemoryRequirements2 sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryRequirements2.nsType(this.address(), value);
        return this;
    }

    public VkMemoryRequirements2 sType$Default() {
        return this.sType(1000146003);
    }

    public VkMemoryRequirements2 pNext(@NativeType(value="void *") long value) {
        VkMemoryRequirements2.npNext(this.address(), value);
        return this;
    }

    public VkMemoryRequirements2 pNext(VkMemoryDedicatedRequirements value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkMemoryRequirements2 pNext(VkMemoryDedicatedRequirementsKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkMemoryRequirements2 set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkMemoryRequirements2 set(VkMemoryRequirements2 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkMemoryRequirements2 malloc() {
        return new VkMemoryRequirements2(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkMemoryRequirements2 calloc() {
        return new VkMemoryRequirements2(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkMemoryRequirements2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkMemoryRequirements2(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkMemoryRequirements2 create(long address) {
        return new VkMemoryRequirements2(address, null);
    }

    @Nullable
    public static VkMemoryRequirements2 createSafe(long address) {
        return address == 0L ? null : new VkMemoryRequirements2(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkMemoryRequirements2.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryRequirements2.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkMemoryRequirements2 mallocStack() {
        return VkMemoryRequirements2.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryRequirements2 callocStack() {
        return VkMemoryRequirements2.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryRequirements2 mallocStack(MemoryStack stack) {
        return VkMemoryRequirements2.malloc(stack);
    }

    @Deprecated
    public static VkMemoryRequirements2 callocStack(MemoryStack stack) {
        return VkMemoryRequirements2.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkMemoryRequirements2.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkMemoryRequirements2.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryRequirements2.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryRequirements2.calloc(capacity, stack);
    }

    public static VkMemoryRequirements2 malloc(MemoryStack stack) {
        return new VkMemoryRequirements2(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMemoryRequirements2 calloc(MemoryStack stack) {
        return new VkMemoryRequirements2(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static VkMemoryRequirements nmemoryRequirements(long struct) {
        return VkMemoryRequirements.create(struct + (long)MEMORYREQUIREMENTS);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    static {
        Struct.Layout layout = VkMemoryRequirements2.__struct((Struct.Member[])new Struct.Member[]{VkMemoryRequirements2.__member((int)4), VkMemoryRequirements2.__member((int)POINTER_SIZE), VkMemoryRequirements2.__member((int)VkMemoryRequirements.SIZEOF, (int)VkMemoryRequirements.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MEMORYREQUIREMENTS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryRequirements2, Buffer>
    implements NativeResource {
        private static final VkMemoryRequirements2 ELEMENT_FACTORY = VkMemoryRequirements2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkMemoryRequirements2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryRequirements2.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkMemoryRequirements2.npNext(this.address());
        }

        public VkMemoryRequirements memoryRequirements() {
            return VkMemoryRequirements2.nmemoryRequirements(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryRequirements2.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000146003);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkMemoryRequirements2.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkMemoryDedicatedRequirements value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkMemoryDedicatedRequirementsKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }
    }
}

