/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryDedicatedRequirements
extends Struct<VkMemoryDedicatedRequirements>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PREFERSDEDICATEDALLOCATION;
    public static final int REQUIRESDEDICATEDALLOCATION;

    protected VkMemoryDedicatedRequirements(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkMemoryDedicatedRequirements create(long address, @Nullable ByteBuffer container) {
        return new VkMemoryDedicatedRequirements(address, container);
    }

    public VkMemoryDedicatedRequirements(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkMemoryDedicatedRequirements.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryDedicatedRequirements.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkMemoryDedicatedRequirements.npNext(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean prefersDedicatedAllocation() {
        return VkMemoryDedicatedRequirements.nprefersDedicatedAllocation(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean requiresDedicatedAllocation() {
        return VkMemoryDedicatedRequirements.nrequiresDedicatedAllocation(this.address()) != 0;
    }

    public VkMemoryDedicatedRequirements sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryDedicatedRequirements.nsType(this.address(), value);
        return this;
    }

    public VkMemoryDedicatedRequirements sType$Default() {
        return this.sType(1000127000);
    }

    public VkMemoryDedicatedRequirements pNext(@NativeType(value="void *") long value) {
        VkMemoryDedicatedRequirements.npNext(this.address(), value);
        return this;
    }

    public VkMemoryDedicatedRequirements set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkMemoryDedicatedRequirements set(VkMemoryDedicatedRequirements src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkMemoryDedicatedRequirements malloc() {
        return new VkMemoryDedicatedRequirements(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkMemoryDedicatedRequirements calloc() {
        return new VkMemoryDedicatedRequirements(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkMemoryDedicatedRequirements create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkMemoryDedicatedRequirements(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkMemoryDedicatedRequirements create(long address) {
        return new VkMemoryDedicatedRequirements(address, null);
    }

    @Nullable
    public static VkMemoryDedicatedRequirements createSafe(long address) {
        return address == 0L ? null : new VkMemoryDedicatedRequirements(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkMemoryDedicatedRequirements.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryDedicatedRequirements.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkMemoryDedicatedRequirements mallocStack() {
        return VkMemoryDedicatedRequirements.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryDedicatedRequirements callocStack() {
        return VkMemoryDedicatedRequirements.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryDedicatedRequirements mallocStack(MemoryStack stack) {
        return VkMemoryDedicatedRequirements.malloc(stack);
    }

    @Deprecated
    public static VkMemoryDedicatedRequirements callocStack(MemoryStack stack) {
        return VkMemoryDedicatedRequirements.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkMemoryDedicatedRequirements.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkMemoryDedicatedRequirements.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryDedicatedRequirements.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryDedicatedRequirements.calloc(capacity, stack);
    }

    public static VkMemoryDedicatedRequirements malloc(MemoryStack stack) {
        return new VkMemoryDedicatedRequirements(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMemoryDedicatedRequirements calloc(MemoryStack stack) {
        return new VkMemoryDedicatedRequirements(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nprefersDedicatedAllocation(long struct) {
        return UNSAFE.getInt(null, struct + (long)PREFERSDEDICATEDALLOCATION);
    }

    public static int nrequiresDedicatedAllocation(long struct) {
        return UNSAFE.getInt(null, struct + (long)REQUIRESDEDICATEDALLOCATION);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    static {
        Struct.Layout layout = VkMemoryDedicatedRequirements.__struct((Struct.Member[])new Struct.Member[]{VkMemoryDedicatedRequirements.__member((int)4), VkMemoryDedicatedRequirements.__member((int)POINTER_SIZE), VkMemoryDedicatedRequirements.__member((int)4), VkMemoryDedicatedRequirements.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PREFERSDEDICATEDALLOCATION = layout.offsetof(2);
        REQUIRESDEDICATEDALLOCATION = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryDedicatedRequirements, Buffer>
    implements NativeResource {
        private static final VkMemoryDedicatedRequirements ELEMENT_FACTORY = VkMemoryDedicatedRequirements.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkMemoryDedicatedRequirements getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryDedicatedRequirements.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkMemoryDedicatedRequirements.npNext(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean prefersDedicatedAllocation() {
            return VkMemoryDedicatedRequirements.nprefersDedicatedAllocation(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean requiresDedicatedAllocation() {
            return VkMemoryDedicatedRequirements.nrequiresDedicatedAllocation(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryDedicatedRequirements.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000127000);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkMemoryDedicatedRequirements.npNext(this.address(), value);
            return this;
        }
    }
}

