/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryAllocateFlagsInfo
extends Struct<VkMemoryAllocateFlagsInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int DEVICEMASK;

    protected VkMemoryAllocateFlagsInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkMemoryAllocateFlagsInfo create(long address, @Nullable ByteBuffer container) {
        return new VkMemoryAllocateFlagsInfo(address, container);
    }

    public VkMemoryAllocateFlagsInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkMemoryAllocateFlagsInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryAllocateFlagsInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMemoryAllocateFlagsInfo.npNext(this.address());
    }

    @NativeType(value="VkMemoryAllocateFlags")
    public int flags() {
        return VkMemoryAllocateFlagsInfo.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int deviceMask() {
        return VkMemoryAllocateFlagsInfo.ndeviceMask(this.address());
    }

    public VkMemoryAllocateFlagsInfo sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryAllocateFlagsInfo.nsType(this.address(), value);
        return this;
    }

    public VkMemoryAllocateFlagsInfo sType$Default() {
        return this.sType(1000060000);
    }

    public VkMemoryAllocateFlagsInfo pNext(@NativeType(value="void const *") long value) {
        VkMemoryAllocateFlagsInfo.npNext(this.address(), value);
        return this;
    }

    public VkMemoryAllocateFlagsInfo flags(@NativeType(value="VkMemoryAllocateFlags") int value) {
        VkMemoryAllocateFlagsInfo.nflags(this.address(), value);
        return this;
    }

    public VkMemoryAllocateFlagsInfo deviceMask(@NativeType(value="uint32_t") int value) {
        VkMemoryAllocateFlagsInfo.ndeviceMask(this.address(), value);
        return this;
    }

    public VkMemoryAllocateFlagsInfo set(int sType, long pNext, int flags, int deviceMask) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.deviceMask(deviceMask);
        return this;
    }

    public VkMemoryAllocateFlagsInfo set(VkMemoryAllocateFlagsInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkMemoryAllocateFlagsInfo malloc() {
        return new VkMemoryAllocateFlagsInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkMemoryAllocateFlagsInfo calloc() {
        return new VkMemoryAllocateFlagsInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkMemoryAllocateFlagsInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkMemoryAllocateFlagsInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkMemoryAllocateFlagsInfo create(long address) {
        return new VkMemoryAllocateFlagsInfo(address, null);
    }

    @Nullable
    public static VkMemoryAllocateFlagsInfo createSafe(long address) {
        return address == 0L ? null : new VkMemoryAllocateFlagsInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkMemoryAllocateFlagsInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryAllocateFlagsInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkMemoryAllocateFlagsInfo mallocStack() {
        return VkMemoryAllocateFlagsInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryAllocateFlagsInfo callocStack() {
        return VkMemoryAllocateFlagsInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryAllocateFlagsInfo mallocStack(MemoryStack stack) {
        return VkMemoryAllocateFlagsInfo.malloc(stack);
    }

    @Deprecated
    public static VkMemoryAllocateFlagsInfo callocStack(MemoryStack stack) {
        return VkMemoryAllocateFlagsInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkMemoryAllocateFlagsInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkMemoryAllocateFlagsInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryAllocateFlagsInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryAllocateFlagsInfo.calloc(capacity, stack);
    }

    public static VkMemoryAllocateFlagsInfo malloc(MemoryStack stack) {
        return new VkMemoryAllocateFlagsInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMemoryAllocateFlagsInfo calloc(MemoryStack stack) {
        return new VkMemoryAllocateFlagsInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int ndeviceMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEVICEMASK);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void ndeviceMask(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DEVICEMASK, value);
    }

    static {
        Struct.Layout layout = VkMemoryAllocateFlagsInfo.__struct((Struct.Member[])new Struct.Member[]{VkMemoryAllocateFlagsInfo.__member((int)4), VkMemoryAllocateFlagsInfo.__member((int)POINTER_SIZE), VkMemoryAllocateFlagsInfo.__member((int)4), VkMemoryAllocateFlagsInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        DEVICEMASK = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryAllocateFlagsInfo, Buffer>
    implements NativeResource {
        private static final VkMemoryAllocateFlagsInfo ELEMENT_FACTORY = VkMemoryAllocateFlagsInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkMemoryAllocateFlagsInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryAllocateFlagsInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMemoryAllocateFlagsInfo.npNext(this.address());
        }

        @NativeType(value="VkMemoryAllocateFlags")
        public int flags() {
            return VkMemoryAllocateFlagsInfo.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int deviceMask() {
            return VkMemoryAllocateFlagsInfo.ndeviceMask(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryAllocateFlagsInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000060000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryAllocateFlagsInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkMemoryAllocateFlags") int value) {
            VkMemoryAllocateFlagsInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer deviceMask(@NativeType(value="uint32_t") int value) {
            VkMemoryAllocateFlagsInfo.ndeviceMask(this.address(), value);
            return this;
        }
    }
}

