/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkLayerSettingEXT
extends Struct<VkLayerSettingEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PLAYERNAME;
    public static final int PSETTINGNAME;
    public static final int TYPE;
    public static final int VALUECOUNT;
    public static final int PVALUES;

    protected VkLayerSettingEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkLayerSettingEXT create(long address, @Nullable ByteBuffer container) {
        return new VkLayerSettingEXT(address, container);
    }

    public VkLayerSettingEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkLayerSettingEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char const *")
    public ByteBuffer pLayerName() {
        return VkLayerSettingEXT.npLayerName(this.address());
    }

    @NativeType(value="char const *")
    public String pLayerNameString() {
        return VkLayerSettingEXT.npLayerNameString(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer pSettingName() {
        return VkLayerSettingEXT.npSettingName(this.address());
    }

    @NativeType(value="char const *")
    public String pSettingNameString() {
        return VkLayerSettingEXT.npSettingNameString(this.address());
    }

    @NativeType(value="VkLayerSettingTypeEXT")
    public int type() {
        return VkLayerSettingEXT.ntype(this.address());
    }

    @NativeType(value="uint32_t")
    public int valueCount() {
        return VkLayerSettingEXT.nvalueCount(this.address());
    }

    @Nullable
    @NativeType(value="void const *")
    public ByteBuffer pValues() {
        return VkLayerSettingEXT.npValues(this.address());
    }

    public VkLayerSettingEXT pLayerName(@NativeType(value="char const *") ByteBuffer value) {
        VkLayerSettingEXT.npLayerName(this.address(), value);
        return this;
    }

    public VkLayerSettingEXT pSettingName(@NativeType(value="char const *") ByteBuffer value) {
        VkLayerSettingEXT.npSettingName(this.address(), value);
        return this;
    }

    public VkLayerSettingEXT type(@NativeType(value="VkLayerSettingTypeEXT") int value) {
        VkLayerSettingEXT.ntype(this.address(), value);
        return this;
    }

    public VkLayerSettingEXT pValues(@Nullable @NativeType(value="void const *") ByteBuffer value) {
        VkLayerSettingEXT.npValues(this.address(), value);
        return this;
    }

    public VkLayerSettingEXT set(ByteBuffer pLayerName, ByteBuffer pSettingName, int type, @Nullable ByteBuffer pValues) {
        this.pLayerName(pLayerName);
        this.pSettingName(pSettingName);
        this.type(type);
        this.pValues(pValues);
        return this;
    }

    public VkLayerSettingEXT set(VkLayerSettingEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkLayerSettingEXT malloc() {
        return new VkLayerSettingEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkLayerSettingEXT calloc() {
        return new VkLayerSettingEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkLayerSettingEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkLayerSettingEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkLayerSettingEXT create(long address) {
        return new VkLayerSettingEXT(address, null);
    }

    @Nullable
    public static VkLayerSettingEXT createSafe(long address) {
        return address == 0L ? null : new VkLayerSettingEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkLayerSettingEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkLayerSettingEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkLayerSettingEXT malloc(MemoryStack stack) {
        return new VkLayerSettingEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkLayerSettingEXT calloc(MemoryStack stack) {
        return new VkLayerSettingEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer npLayerName(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)PLAYERNAME)));
    }

    public static String npLayerNameString(long struct) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memGetAddress((long)(struct + (long)PLAYERNAME)));
    }

    public static ByteBuffer npSettingName(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)PSETTINGNAME)));
    }

    public static String npSettingNameString(long struct) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memGetAddress((long)(struct + (long)PSETTINGNAME)));
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static int nvalueCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)VALUECOUNT);
    }

    @Nullable
    public static ByteBuffer npValues(long struct) {
        return MemoryUtil.memByteBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PVALUES)), (int)VkLayerSettingEXT.nvalueCount(struct));
    }

    public static void npLayerName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)PLAYERNAME), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void npSettingName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)PSETTINGNAME), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nvalueCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VALUECOUNT, value);
    }

    public static void npValues(long struct, @Nullable ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PVALUES), (long)MemoryUtil.memAddressSafe((ByteBuffer)value));
        VkLayerSettingEXT.nvalueCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PLAYERNAME)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PSETTINGNAME)));
        if (VkLayerSettingEXT.nvalueCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PVALUES)));
        }
    }

    static {
        Struct.Layout layout = VkLayerSettingEXT.__struct((Struct.Member[])new Struct.Member[]{VkLayerSettingEXT.__member((int)POINTER_SIZE), VkLayerSettingEXT.__member((int)POINTER_SIZE), VkLayerSettingEXT.__member((int)4), VkLayerSettingEXT.__member((int)4), VkLayerSettingEXT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PLAYERNAME = layout.offsetof(0);
        PSETTINGNAME = layout.offsetof(1);
        TYPE = layout.offsetof(2);
        VALUECOUNT = layout.offsetof(3);
        PVALUES = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkLayerSettingEXT, Buffer>
    implements NativeResource {
        private static final VkLayerSettingEXT ELEMENT_FACTORY = VkLayerSettingEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkLayerSettingEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char const *")
        public ByteBuffer pLayerName() {
            return VkLayerSettingEXT.npLayerName(this.address());
        }

        @NativeType(value="char const *")
        public String pLayerNameString() {
            return VkLayerSettingEXT.npLayerNameString(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer pSettingName() {
            return VkLayerSettingEXT.npSettingName(this.address());
        }

        @NativeType(value="char const *")
        public String pSettingNameString() {
            return VkLayerSettingEXT.npSettingNameString(this.address());
        }

        @NativeType(value="VkLayerSettingTypeEXT")
        public int type() {
            return VkLayerSettingEXT.ntype(this.address());
        }

        @NativeType(value="uint32_t")
        public int valueCount() {
            return VkLayerSettingEXT.nvalueCount(this.address());
        }

        @Nullable
        @NativeType(value="void const *")
        public ByteBuffer pValues() {
            return VkLayerSettingEXT.npValues(this.address());
        }

        public Buffer pLayerName(@NativeType(value="char const *") ByteBuffer value) {
            VkLayerSettingEXT.npLayerName(this.address(), value);
            return this;
        }

        public Buffer pSettingName(@NativeType(value="char const *") ByteBuffer value) {
            VkLayerSettingEXT.npSettingName(this.address(), value);
            return this;
        }

        public Buffer type(@NativeType(value="VkLayerSettingTypeEXT") int value) {
            VkLayerSettingEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer pValues(@Nullable @NativeType(value="void const *") ByteBuffer value) {
            VkLayerSettingEXT.npValues(this.address(), value);
            return this;
        }
    }
}

