/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkGraphicsShaderGroupCreateInfoNV;

public class VkGraphicsPipelineShaderGroupsCreateInfoNV
extends Struct<VkGraphicsPipelineShaderGroupsCreateInfoNV>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int GROUPCOUNT;
    public static final int PGROUPS;
    public static final int PIPELINECOUNT;
    public static final int PPIPELINES;

    protected VkGraphicsPipelineShaderGroupsCreateInfoNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkGraphicsPipelineShaderGroupsCreateInfoNV create(long address, @Nullable ByteBuffer container) {
        return new VkGraphicsPipelineShaderGroupsCreateInfoNV(address, container);
    }

    public VkGraphicsPipelineShaderGroupsCreateInfoNV(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkGraphicsPipelineShaderGroupsCreateInfoNV.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkGraphicsPipelineShaderGroupsCreateInfoNV.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkGraphicsPipelineShaderGroupsCreateInfoNV.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int groupCount() {
        return VkGraphicsPipelineShaderGroupsCreateInfoNV.ngroupCount(this.address());
    }

    @Nullable
    @NativeType(value="VkGraphicsShaderGroupCreateInfoNV const *")
    public VkGraphicsShaderGroupCreateInfoNV.Buffer pGroups() {
        return VkGraphicsPipelineShaderGroupsCreateInfoNV.npGroups(this.address());
    }

    @NativeType(value="uint32_t")
    public int pipelineCount() {
        return VkGraphicsPipelineShaderGroupsCreateInfoNV.npipelineCount(this.address());
    }

    @Nullable
    @NativeType(value="VkPipeline const *")
    public LongBuffer pPipelines() {
        return VkGraphicsPipelineShaderGroupsCreateInfoNV.npPipelines(this.address());
    }

    public VkGraphicsPipelineShaderGroupsCreateInfoNV sType(@NativeType(value="VkStructureType") int value) {
        VkGraphicsPipelineShaderGroupsCreateInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineShaderGroupsCreateInfoNV sType$Default() {
        return this.sType(1000277002);
    }

    public VkGraphicsPipelineShaderGroupsCreateInfoNV pNext(@NativeType(value="void const *") long value) {
        VkGraphicsPipelineShaderGroupsCreateInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineShaderGroupsCreateInfoNV pGroups(@Nullable @NativeType(value="VkGraphicsShaderGroupCreateInfoNV const *") VkGraphicsShaderGroupCreateInfoNV.Buffer value) {
        VkGraphicsPipelineShaderGroupsCreateInfoNV.npGroups(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineShaderGroupsCreateInfoNV pPipelines(@Nullable @NativeType(value="VkPipeline const *") LongBuffer value) {
        VkGraphicsPipelineShaderGroupsCreateInfoNV.npPipelines(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineShaderGroupsCreateInfoNV set(int sType, long pNext, @Nullable VkGraphicsShaderGroupCreateInfoNV.Buffer pGroups, @Nullable LongBuffer pPipelines) {
        this.sType(sType);
        this.pNext(pNext);
        this.pGroups(pGroups);
        this.pPipelines(pPipelines);
        return this;
    }

    public VkGraphicsPipelineShaderGroupsCreateInfoNV set(VkGraphicsPipelineShaderGroupsCreateInfoNV src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkGraphicsPipelineShaderGroupsCreateInfoNV malloc() {
        return new VkGraphicsPipelineShaderGroupsCreateInfoNV(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkGraphicsPipelineShaderGroupsCreateInfoNV calloc() {
        return new VkGraphicsPipelineShaderGroupsCreateInfoNV(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkGraphicsPipelineShaderGroupsCreateInfoNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkGraphicsPipelineShaderGroupsCreateInfoNV(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkGraphicsPipelineShaderGroupsCreateInfoNV create(long address) {
        return new VkGraphicsPipelineShaderGroupsCreateInfoNV(address, null);
    }

    @Nullable
    public static VkGraphicsPipelineShaderGroupsCreateInfoNV createSafe(long address) {
        return address == 0L ? null : new VkGraphicsPipelineShaderGroupsCreateInfoNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkGraphicsPipelineShaderGroupsCreateInfoNV.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkGraphicsPipelineShaderGroupsCreateInfoNV.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkGraphicsPipelineShaderGroupsCreateInfoNV malloc(MemoryStack stack) {
        return new VkGraphicsPipelineShaderGroupsCreateInfoNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkGraphicsPipelineShaderGroupsCreateInfoNV calloc(MemoryStack stack) {
        return new VkGraphicsPipelineShaderGroupsCreateInfoNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int ngroupCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)GROUPCOUNT);
    }

    @Nullable
    public static VkGraphicsShaderGroupCreateInfoNV.Buffer npGroups(long struct) {
        return VkGraphicsShaderGroupCreateInfoNV.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PGROUPS)), VkGraphicsPipelineShaderGroupsCreateInfoNV.ngroupCount(struct));
    }

    public static int npipelineCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)PIPELINECOUNT);
    }

    @Nullable
    public static LongBuffer npPipelines(long struct) {
        return MemoryUtil.memLongBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PPIPELINES)), (int)VkGraphicsPipelineShaderGroupsCreateInfoNV.npipelineCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void ngroupCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)GROUPCOUNT, value);
    }

    public static void npGroups(long struct, @Nullable VkGraphicsShaderGroupCreateInfoNV.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PGROUPS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkGraphicsPipelineShaderGroupsCreateInfoNV.ngroupCount(struct, value == null ? 0 : value.remaining());
    }

    public static void npipelineCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PIPELINECOUNT, value);
    }

    public static void npPipelines(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PPIPELINES), (long)MemoryUtil.memAddressSafe((LongBuffer)value));
        VkGraphicsPipelineShaderGroupsCreateInfoNV.npipelineCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        int groupCount = VkGraphicsPipelineShaderGroupsCreateInfoNV.ngroupCount(struct);
        if (groupCount != 0) {
            long pGroups = MemoryUtil.memGetAddress((long)(struct + (long)PGROUPS));
            Checks.check((long)pGroups);
            VkGraphicsPipelineShaderGroupsCreateInfoNV.validate((long)pGroups, (int)groupCount, (int)VkGraphicsShaderGroupCreateInfoNV.SIZEOF, VkGraphicsShaderGroupCreateInfoNV::validate);
        }
        if (VkGraphicsPipelineShaderGroupsCreateInfoNV.npipelineCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PPIPELINES)));
        }
    }

    static {
        Struct.Layout layout = VkGraphicsPipelineShaderGroupsCreateInfoNV.__struct((Struct.Member[])new Struct.Member[]{VkGraphicsPipelineShaderGroupsCreateInfoNV.__member((int)4), VkGraphicsPipelineShaderGroupsCreateInfoNV.__member((int)POINTER_SIZE), VkGraphicsPipelineShaderGroupsCreateInfoNV.__member((int)4), VkGraphicsPipelineShaderGroupsCreateInfoNV.__member((int)POINTER_SIZE), VkGraphicsPipelineShaderGroupsCreateInfoNV.__member((int)4), VkGraphicsPipelineShaderGroupsCreateInfoNV.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        GROUPCOUNT = layout.offsetof(2);
        PGROUPS = layout.offsetof(3);
        PIPELINECOUNT = layout.offsetof(4);
        PPIPELINES = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkGraphicsPipelineShaderGroupsCreateInfoNV, Buffer>
    implements NativeResource {
        private static final VkGraphicsPipelineShaderGroupsCreateInfoNV ELEMENT_FACTORY = VkGraphicsPipelineShaderGroupsCreateInfoNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkGraphicsPipelineShaderGroupsCreateInfoNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkGraphicsPipelineShaderGroupsCreateInfoNV.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkGraphicsPipelineShaderGroupsCreateInfoNV.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int groupCount() {
            return VkGraphicsPipelineShaderGroupsCreateInfoNV.ngroupCount(this.address());
        }

        @Nullable
        @NativeType(value="VkGraphicsShaderGroupCreateInfoNV const *")
        public VkGraphicsShaderGroupCreateInfoNV.Buffer pGroups() {
            return VkGraphicsPipelineShaderGroupsCreateInfoNV.npGroups(this.address());
        }

        @NativeType(value="uint32_t")
        public int pipelineCount() {
            return VkGraphicsPipelineShaderGroupsCreateInfoNV.npipelineCount(this.address());
        }

        @Nullable
        @NativeType(value="VkPipeline const *")
        public LongBuffer pPipelines() {
            return VkGraphicsPipelineShaderGroupsCreateInfoNV.npPipelines(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkGraphicsPipelineShaderGroupsCreateInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000277002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkGraphicsPipelineShaderGroupsCreateInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer pGroups(@Nullable @NativeType(value="VkGraphicsShaderGroupCreateInfoNV const *") VkGraphicsShaderGroupCreateInfoNV.Buffer value) {
            VkGraphicsPipelineShaderGroupsCreateInfoNV.npGroups(this.address(), value);
            return this;
        }

        public Buffer pPipelines(@Nullable @NativeType(value="VkPipeline const *") LongBuffer value) {
            VkGraphicsPipelineShaderGroupsCreateInfoNV.npPipelines(this.address(), value);
            return this;
        }
    }
}

