/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExportMetalBufferInfoEXT
extends Struct<VkExportMetalBufferInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MEMORY;
    public static final int MTLBUFFER;

    protected VkExportMetalBufferInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkExportMetalBufferInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkExportMetalBufferInfoEXT(address, container);
    }

    public VkExportMetalBufferInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkExportMetalBufferInfoEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkExportMetalBufferInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkExportMetalBufferInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkDeviceMemory")
    public long memory() {
        return VkExportMetalBufferInfoEXT.nmemory(this.address());
    }

    @NativeType(value="MTLBuffer_id")
    public long mtlBuffer() {
        return VkExportMetalBufferInfoEXT.nmtlBuffer(this.address());
    }

    public VkExportMetalBufferInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkExportMetalBufferInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkExportMetalBufferInfoEXT sType$Default() {
        return this.sType(1000311004);
    }

    public VkExportMetalBufferInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkExportMetalBufferInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkExportMetalBufferInfoEXT memory(@NativeType(value="VkDeviceMemory") long value) {
        VkExportMetalBufferInfoEXT.nmemory(this.address(), value);
        return this;
    }

    public VkExportMetalBufferInfoEXT mtlBuffer(@NativeType(value="MTLBuffer_id") long value) {
        VkExportMetalBufferInfoEXT.nmtlBuffer(this.address(), value);
        return this;
    }

    public VkExportMetalBufferInfoEXT set(int sType, long pNext, long memory, long mtlBuffer) {
        this.sType(sType);
        this.pNext(pNext);
        this.memory(memory);
        this.mtlBuffer(mtlBuffer);
        return this;
    }

    public VkExportMetalBufferInfoEXT set(VkExportMetalBufferInfoEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkExportMetalBufferInfoEXT malloc() {
        return new VkExportMetalBufferInfoEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkExportMetalBufferInfoEXT calloc() {
        return new VkExportMetalBufferInfoEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkExportMetalBufferInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkExportMetalBufferInfoEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkExportMetalBufferInfoEXT create(long address) {
        return new VkExportMetalBufferInfoEXT(address, null);
    }

    @Nullable
    public static VkExportMetalBufferInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkExportMetalBufferInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkExportMetalBufferInfoEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkExportMetalBufferInfoEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkExportMetalBufferInfoEXT malloc(MemoryStack stack) {
        return new VkExportMetalBufferInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkExportMetalBufferInfoEXT calloc(MemoryStack stack) {
        return new VkExportMetalBufferInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nmemory(long struct) {
        return UNSAFE.getLong(null, struct + (long)MEMORY);
    }

    public static long nmtlBuffer(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)MTLBUFFER));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nmemory(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MEMORY, value);
    }

    public static void nmtlBuffer(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MTLBUFFER), (long)Checks.check((long)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MTLBUFFER)));
    }

    static {
        Struct.Layout layout = VkExportMetalBufferInfoEXT.__struct((Struct.Member[])new Struct.Member[]{VkExportMetalBufferInfoEXT.__member((int)4), VkExportMetalBufferInfoEXT.__member((int)POINTER_SIZE), VkExportMetalBufferInfoEXT.__member((int)8), VkExportMetalBufferInfoEXT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MEMORY = layout.offsetof(2);
        MTLBUFFER = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkExportMetalBufferInfoEXT, Buffer>
    implements NativeResource {
        private static final VkExportMetalBufferInfoEXT ELEMENT_FACTORY = VkExportMetalBufferInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkExportMetalBufferInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkExportMetalBufferInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkExportMetalBufferInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkDeviceMemory")
        public long memory() {
            return VkExportMetalBufferInfoEXT.nmemory(this.address());
        }

        @NativeType(value="MTLBuffer_id")
        public long mtlBuffer() {
            return VkExportMetalBufferInfoEXT.nmtlBuffer(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExportMetalBufferInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000311004);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkExportMetalBufferInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer memory(@NativeType(value="VkDeviceMemory") long value) {
            VkExportMetalBufferInfoEXT.nmemory(this.address(), value);
            return this;
        }

        public Buffer mtlBuffer(@NativeType(value="MTLBuffer_id") long value) {
            VkExportMetalBufferInfoEXT.nmtlBuffer(this.address(), value);
            return this;
        }
    }
}

