/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDescriptorAddressInfoEXT;
import org.lwjgl.vulkan.VkDescriptorImageInfo;

public class VkDescriptorDataEXT
extends Struct<VkDescriptorDataEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PSAMPLER;
    public static final int PCOMBINEDIMAGESAMPLER;
    public static final int PINPUTATTACHMENTIMAGE;
    public static final int PSAMPLEDIMAGE;
    public static final int PSTORAGEIMAGE;
    public static final int PUNIFORMTEXELBUFFER;
    public static final int PSTORAGETEXELBUFFER;
    public static final int PUNIFORMBUFFER;
    public static final int PSTORAGEBUFFER;
    public static final int ACCELERATIONSTRUCTURE;

    protected VkDescriptorDataEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkDescriptorDataEXT create(long address, @Nullable ByteBuffer container) {
        return new VkDescriptorDataEXT(address, container);
    }

    public VkDescriptorDataEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDescriptorDataEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkSampler const *")
    public LongBuffer pSampler(int capacity) {
        return VkDescriptorDataEXT.npSampler(this.address(), capacity);
    }

    @NativeType(value="VkDescriptorImageInfo const *")
    public VkDescriptorImageInfo pCombinedImageSampler() {
        return VkDescriptorDataEXT.npCombinedImageSampler(this.address());
    }

    @NativeType(value="VkDescriptorImageInfo const *")
    public VkDescriptorImageInfo pInputAttachmentImage() {
        return VkDescriptorDataEXT.npInputAttachmentImage(this.address());
    }

    @Nullable
    @NativeType(value="VkDescriptorImageInfo const *")
    public VkDescriptorImageInfo pSampledImage() {
        return VkDescriptorDataEXT.npSampledImage(this.address());
    }

    @Nullable
    @NativeType(value="VkDescriptorImageInfo const *")
    public VkDescriptorImageInfo pStorageImage() {
        return VkDescriptorDataEXT.npStorageImage(this.address());
    }

    @Nullable
    @NativeType(value="VkDescriptorAddressInfoEXT const *")
    public VkDescriptorAddressInfoEXT pUniformTexelBuffer() {
        return VkDescriptorDataEXT.npUniformTexelBuffer(this.address());
    }

    @Nullable
    @NativeType(value="VkDescriptorAddressInfoEXT const *")
    public VkDescriptorAddressInfoEXT pStorageTexelBuffer() {
        return VkDescriptorDataEXT.npStorageTexelBuffer(this.address());
    }

    @Nullable
    @NativeType(value="VkDescriptorAddressInfoEXT const *")
    public VkDescriptorAddressInfoEXT pUniformBuffer() {
        return VkDescriptorDataEXT.npUniformBuffer(this.address());
    }

    @Nullable
    @NativeType(value="VkDescriptorAddressInfoEXT const *")
    public VkDescriptorAddressInfoEXT pStorageBuffer() {
        return VkDescriptorDataEXT.npStorageBuffer(this.address());
    }

    @NativeType(value="VkDeviceAddress")
    public long accelerationStructure() {
        return VkDescriptorDataEXT.naccelerationStructure(this.address());
    }

    public VkDescriptorDataEXT pSampler(@NativeType(value="VkSampler const *") LongBuffer value) {
        VkDescriptorDataEXT.npSampler(this.address(), value);
        return this;
    }

    public VkDescriptorDataEXT pCombinedImageSampler(@NativeType(value="VkDescriptorImageInfo const *") VkDescriptorImageInfo value) {
        VkDescriptorDataEXT.npCombinedImageSampler(this.address(), value);
        return this;
    }

    public VkDescriptorDataEXT pInputAttachmentImage(@NativeType(value="VkDescriptorImageInfo const *") VkDescriptorImageInfo value) {
        VkDescriptorDataEXT.npInputAttachmentImage(this.address(), value);
        return this;
    }

    public VkDescriptorDataEXT pSampledImage(@Nullable @NativeType(value="VkDescriptorImageInfo const *") VkDescriptorImageInfo value) {
        VkDescriptorDataEXT.npSampledImage(this.address(), value);
        return this;
    }

    public VkDescriptorDataEXT pStorageImage(@Nullable @NativeType(value="VkDescriptorImageInfo const *") VkDescriptorImageInfo value) {
        VkDescriptorDataEXT.npStorageImage(this.address(), value);
        return this;
    }

    public VkDescriptorDataEXT pUniformTexelBuffer(@Nullable @NativeType(value="VkDescriptorAddressInfoEXT const *") VkDescriptorAddressInfoEXT value) {
        VkDescriptorDataEXT.npUniformTexelBuffer(this.address(), value);
        return this;
    }

    public VkDescriptorDataEXT pStorageTexelBuffer(@Nullable @NativeType(value="VkDescriptorAddressInfoEXT const *") VkDescriptorAddressInfoEXT value) {
        VkDescriptorDataEXT.npStorageTexelBuffer(this.address(), value);
        return this;
    }

    public VkDescriptorDataEXT pUniformBuffer(@Nullable @NativeType(value="VkDescriptorAddressInfoEXT const *") VkDescriptorAddressInfoEXT value) {
        VkDescriptorDataEXT.npUniformBuffer(this.address(), value);
        return this;
    }

    public VkDescriptorDataEXT pStorageBuffer(@Nullable @NativeType(value="VkDescriptorAddressInfoEXT const *") VkDescriptorAddressInfoEXT value) {
        VkDescriptorDataEXT.npStorageBuffer(this.address(), value);
        return this;
    }

    public VkDescriptorDataEXT accelerationStructure(@NativeType(value="VkDeviceAddress") long value) {
        VkDescriptorDataEXT.naccelerationStructure(this.address(), value);
        return this;
    }

    public VkDescriptorDataEXT set(VkDescriptorDataEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDescriptorDataEXT malloc() {
        return new VkDescriptorDataEXT(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkDescriptorDataEXT calloc() {
        return new VkDescriptorDataEXT(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkDescriptorDataEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkDescriptorDataEXT(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkDescriptorDataEXT create(long address) {
        return new VkDescriptorDataEXT(address, null);
    }

    @Nullable
    public static VkDescriptorDataEXT createSafe(long address) {
        return address == 0L ? null : new VkDescriptorDataEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkDescriptorDataEXT.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDescriptorDataEXT.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkDescriptorDataEXT malloc(MemoryStack stack) {
        return new VkDescriptorDataEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDescriptorDataEXT calloc(MemoryStack stack) {
        return new VkDescriptorDataEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static LongBuffer npSampler(long struct, int capacity) {
        return MemoryUtil.memLongBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PSAMPLER)), (int)capacity);
    }

    public static VkDescriptorImageInfo npCombinedImageSampler(long struct) {
        return VkDescriptorImageInfo.create(MemoryUtil.memGetAddress((long)(struct + (long)PCOMBINEDIMAGESAMPLER)));
    }

    public static VkDescriptorImageInfo npInputAttachmentImage(long struct) {
        return VkDescriptorImageInfo.create(MemoryUtil.memGetAddress((long)(struct + (long)PINPUTATTACHMENTIMAGE)));
    }

    @Nullable
    public static VkDescriptorImageInfo npSampledImage(long struct) {
        return VkDescriptorImageInfo.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PSAMPLEDIMAGE)));
    }

    @Nullable
    public static VkDescriptorImageInfo npStorageImage(long struct) {
        return VkDescriptorImageInfo.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PSTORAGEIMAGE)));
    }

    @Nullable
    public static VkDescriptorAddressInfoEXT npUniformTexelBuffer(long struct) {
        return VkDescriptorAddressInfoEXT.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PUNIFORMTEXELBUFFER)));
    }

    @Nullable
    public static VkDescriptorAddressInfoEXT npStorageTexelBuffer(long struct) {
        return VkDescriptorAddressInfoEXT.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PSTORAGETEXELBUFFER)));
    }

    @Nullable
    public static VkDescriptorAddressInfoEXT npUniformBuffer(long struct) {
        return VkDescriptorAddressInfoEXT.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PUNIFORMBUFFER)));
    }

    @Nullable
    public static VkDescriptorAddressInfoEXT npStorageBuffer(long struct) {
        return VkDescriptorAddressInfoEXT.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PSTORAGEBUFFER)));
    }

    public static long naccelerationStructure(long struct) {
        return UNSAFE.getLong(null, struct + (long)ACCELERATIONSTRUCTURE);
    }

    public static void npSampler(long struct, LongBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSAMPLER), (long)MemoryUtil.memAddress((LongBuffer)value));
    }

    public static void npCombinedImageSampler(long struct, VkDescriptorImageInfo value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PCOMBINEDIMAGESAMPLER), (long)value.address());
    }

    public static void npInputAttachmentImage(long struct, VkDescriptorImageInfo value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PINPUTATTACHMENTIMAGE), (long)value.address());
    }

    public static void npSampledImage(long struct, @Nullable VkDescriptorImageInfo value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSAMPLEDIMAGE), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void npStorageImage(long struct, @Nullable VkDescriptorImageInfo value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSTORAGEIMAGE), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void npUniformTexelBuffer(long struct, @Nullable VkDescriptorAddressInfoEXT value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PUNIFORMTEXELBUFFER), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void npStorageTexelBuffer(long struct, @Nullable VkDescriptorAddressInfoEXT value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSTORAGETEXELBUFFER), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void npUniformBuffer(long struct, @Nullable VkDescriptorAddressInfoEXT value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PUNIFORMBUFFER), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void npStorageBuffer(long struct, @Nullable VkDescriptorAddressInfoEXT value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSTORAGEBUFFER), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void naccelerationStructure(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)ACCELERATIONSTRUCTURE, value);
    }

    static {
        Struct.Layout layout = VkDescriptorDataEXT.__union((Struct.Member[])new Struct.Member[]{VkDescriptorDataEXT.__member((int)POINTER_SIZE), VkDescriptorDataEXT.__member((int)POINTER_SIZE), VkDescriptorDataEXT.__member((int)POINTER_SIZE), VkDescriptorDataEXT.__member((int)POINTER_SIZE), VkDescriptorDataEXT.__member((int)POINTER_SIZE), VkDescriptorDataEXT.__member((int)POINTER_SIZE), VkDescriptorDataEXT.__member((int)POINTER_SIZE), VkDescriptorDataEXT.__member((int)POINTER_SIZE), VkDescriptorDataEXT.__member((int)POINTER_SIZE), VkDescriptorDataEXT.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PSAMPLER = layout.offsetof(0);
        PCOMBINEDIMAGESAMPLER = layout.offsetof(1);
        PINPUTATTACHMENTIMAGE = layout.offsetof(2);
        PSAMPLEDIMAGE = layout.offsetof(3);
        PSTORAGEIMAGE = layout.offsetof(4);
        PUNIFORMTEXELBUFFER = layout.offsetof(5);
        PSTORAGETEXELBUFFER = layout.offsetof(6);
        PUNIFORMBUFFER = layout.offsetof(7);
        PSTORAGEBUFFER = layout.offsetof(8);
        ACCELERATIONSTRUCTURE = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<VkDescriptorDataEXT, Buffer>
    implements NativeResource {
        private static final VkDescriptorDataEXT ELEMENT_FACTORY = VkDescriptorDataEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDescriptorDataEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkSampler const *")
        public LongBuffer pSampler(int capacity) {
            return VkDescriptorDataEXT.npSampler(this.address(), capacity);
        }

        @NativeType(value="VkDescriptorImageInfo const *")
        public VkDescriptorImageInfo pCombinedImageSampler() {
            return VkDescriptorDataEXT.npCombinedImageSampler(this.address());
        }

        @NativeType(value="VkDescriptorImageInfo const *")
        public VkDescriptorImageInfo pInputAttachmentImage() {
            return VkDescriptorDataEXT.npInputAttachmentImage(this.address());
        }

        @Nullable
        @NativeType(value="VkDescriptorImageInfo const *")
        public VkDescriptorImageInfo pSampledImage() {
            return VkDescriptorDataEXT.npSampledImage(this.address());
        }

        @Nullable
        @NativeType(value="VkDescriptorImageInfo const *")
        public VkDescriptorImageInfo pStorageImage() {
            return VkDescriptorDataEXT.npStorageImage(this.address());
        }

        @Nullable
        @NativeType(value="VkDescriptorAddressInfoEXT const *")
        public VkDescriptorAddressInfoEXT pUniformTexelBuffer() {
            return VkDescriptorDataEXT.npUniformTexelBuffer(this.address());
        }

        @Nullable
        @NativeType(value="VkDescriptorAddressInfoEXT const *")
        public VkDescriptorAddressInfoEXT pStorageTexelBuffer() {
            return VkDescriptorDataEXT.npStorageTexelBuffer(this.address());
        }

        @Nullable
        @NativeType(value="VkDescriptorAddressInfoEXT const *")
        public VkDescriptorAddressInfoEXT pUniformBuffer() {
            return VkDescriptorDataEXT.npUniformBuffer(this.address());
        }

        @Nullable
        @NativeType(value="VkDescriptorAddressInfoEXT const *")
        public VkDescriptorAddressInfoEXT pStorageBuffer() {
            return VkDescriptorDataEXT.npStorageBuffer(this.address());
        }

        @NativeType(value="VkDeviceAddress")
        public long accelerationStructure() {
            return VkDescriptorDataEXT.naccelerationStructure(this.address());
        }

        public Buffer pSampler(@NativeType(value="VkSampler const *") LongBuffer value) {
            VkDescriptorDataEXT.npSampler(this.address(), value);
            return this;
        }

        public Buffer pCombinedImageSampler(@NativeType(value="VkDescriptorImageInfo const *") VkDescriptorImageInfo value) {
            VkDescriptorDataEXT.npCombinedImageSampler(this.address(), value);
            return this;
        }

        public Buffer pInputAttachmentImage(@NativeType(value="VkDescriptorImageInfo const *") VkDescriptorImageInfo value) {
            VkDescriptorDataEXT.npInputAttachmentImage(this.address(), value);
            return this;
        }

        public Buffer pSampledImage(@Nullable @NativeType(value="VkDescriptorImageInfo const *") VkDescriptorImageInfo value) {
            VkDescriptorDataEXT.npSampledImage(this.address(), value);
            return this;
        }

        public Buffer pStorageImage(@Nullable @NativeType(value="VkDescriptorImageInfo const *") VkDescriptorImageInfo value) {
            VkDescriptorDataEXT.npStorageImage(this.address(), value);
            return this;
        }

        public Buffer pUniformTexelBuffer(@Nullable @NativeType(value="VkDescriptorAddressInfoEXT const *") VkDescriptorAddressInfoEXT value) {
            VkDescriptorDataEXT.npUniformTexelBuffer(this.address(), value);
            return this;
        }

        public Buffer pStorageTexelBuffer(@Nullable @NativeType(value="VkDescriptorAddressInfoEXT const *") VkDescriptorAddressInfoEXT value) {
            VkDescriptorDataEXT.npStorageTexelBuffer(this.address(), value);
            return this;
        }

        public Buffer pUniformBuffer(@Nullable @NativeType(value="VkDescriptorAddressInfoEXT const *") VkDescriptorAddressInfoEXT value) {
            VkDescriptorDataEXT.npUniformBuffer(this.address(), value);
            return this;
        }

        public Buffer pStorageBuffer(@Nullable @NativeType(value="VkDescriptorAddressInfoEXT const *") VkDescriptorAddressInfoEXT value) {
            VkDescriptorDataEXT.npStorageBuffer(this.address(), value);
            return this;
        }

        public Buffer accelerationStructure(@NativeType(value="VkDeviceAddress") long value) {
            VkDescriptorDataEXT.naccelerationStructure(this.address(), value);
            return this;
        }
    }
}

