/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent3D;
import org.lwjgl.vulkan.VkImageSubresourceLayers;
import org.lwjgl.vulkan.VkOffset3D;

public class VkCopyMemoryToImageIndirectCommandNV
extends Struct<VkCopyMemoryToImageIndirectCommandNV>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SRCADDRESS;
    public static final int BUFFERROWLENGTH;
    public static final int BUFFERIMAGEHEIGHT;
    public static final int IMAGESUBRESOURCE;
    public static final int IMAGEOFFSET;
    public static final int IMAGEEXTENT;

    protected VkCopyMemoryToImageIndirectCommandNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkCopyMemoryToImageIndirectCommandNV create(long address, @Nullable ByteBuffer container) {
        return new VkCopyMemoryToImageIndirectCommandNV(address, container);
    }

    public VkCopyMemoryToImageIndirectCommandNV(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkCopyMemoryToImageIndirectCommandNV.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceAddress")
    public long srcAddress() {
        return VkCopyMemoryToImageIndirectCommandNV.nsrcAddress(this.address());
    }

    @NativeType(value="uint32_t")
    public int bufferRowLength() {
        return VkCopyMemoryToImageIndirectCommandNV.nbufferRowLength(this.address());
    }

    @NativeType(value="uint32_t")
    public int bufferImageHeight() {
        return VkCopyMemoryToImageIndirectCommandNV.nbufferImageHeight(this.address());
    }

    public VkImageSubresourceLayers imageSubresource() {
        return VkCopyMemoryToImageIndirectCommandNV.nimageSubresource(this.address());
    }

    public VkOffset3D imageOffset() {
        return VkCopyMemoryToImageIndirectCommandNV.nimageOffset(this.address());
    }

    public VkExtent3D imageExtent() {
        return VkCopyMemoryToImageIndirectCommandNV.nimageExtent(this.address());
    }

    public VkCopyMemoryToImageIndirectCommandNV srcAddress(@NativeType(value="VkDeviceAddress") long value) {
        VkCopyMemoryToImageIndirectCommandNV.nsrcAddress(this.address(), value);
        return this;
    }

    public VkCopyMemoryToImageIndirectCommandNV bufferRowLength(@NativeType(value="uint32_t") int value) {
        VkCopyMemoryToImageIndirectCommandNV.nbufferRowLength(this.address(), value);
        return this;
    }

    public VkCopyMemoryToImageIndirectCommandNV bufferImageHeight(@NativeType(value="uint32_t") int value) {
        VkCopyMemoryToImageIndirectCommandNV.nbufferImageHeight(this.address(), value);
        return this;
    }

    public VkCopyMemoryToImageIndirectCommandNV imageSubresource(VkImageSubresourceLayers value) {
        VkCopyMemoryToImageIndirectCommandNV.nimageSubresource(this.address(), value);
        return this;
    }

    public VkCopyMemoryToImageIndirectCommandNV imageSubresource(Consumer<VkImageSubresourceLayers> consumer) {
        consumer.accept(this.imageSubresource());
        return this;
    }

    public VkCopyMemoryToImageIndirectCommandNV imageOffset(VkOffset3D value) {
        VkCopyMemoryToImageIndirectCommandNV.nimageOffset(this.address(), value);
        return this;
    }

    public VkCopyMemoryToImageIndirectCommandNV imageOffset(Consumer<VkOffset3D> consumer) {
        consumer.accept(this.imageOffset());
        return this;
    }

    public VkCopyMemoryToImageIndirectCommandNV imageExtent(VkExtent3D value) {
        VkCopyMemoryToImageIndirectCommandNV.nimageExtent(this.address(), value);
        return this;
    }

    public VkCopyMemoryToImageIndirectCommandNV imageExtent(Consumer<VkExtent3D> consumer) {
        consumer.accept(this.imageExtent());
        return this;
    }

    public VkCopyMemoryToImageIndirectCommandNV set(long srcAddress, int bufferRowLength, int bufferImageHeight, VkImageSubresourceLayers imageSubresource, VkOffset3D imageOffset, VkExtent3D imageExtent) {
        this.srcAddress(srcAddress);
        this.bufferRowLength(bufferRowLength);
        this.bufferImageHeight(bufferImageHeight);
        this.imageSubresource(imageSubresource);
        this.imageOffset(imageOffset);
        this.imageExtent(imageExtent);
        return this;
    }

    public VkCopyMemoryToImageIndirectCommandNV set(VkCopyMemoryToImageIndirectCommandNV src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkCopyMemoryToImageIndirectCommandNV malloc() {
        return new VkCopyMemoryToImageIndirectCommandNV(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkCopyMemoryToImageIndirectCommandNV calloc() {
        return new VkCopyMemoryToImageIndirectCommandNV(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkCopyMemoryToImageIndirectCommandNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkCopyMemoryToImageIndirectCommandNV(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkCopyMemoryToImageIndirectCommandNV create(long address) {
        return new VkCopyMemoryToImageIndirectCommandNV(address, null);
    }

    @Nullable
    public static VkCopyMemoryToImageIndirectCommandNV createSafe(long address) {
        return address == 0L ? null : new VkCopyMemoryToImageIndirectCommandNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkCopyMemoryToImageIndirectCommandNV.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCopyMemoryToImageIndirectCommandNV.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkCopyMemoryToImageIndirectCommandNV malloc(MemoryStack stack) {
        return new VkCopyMemoryToImageIndirectCommandNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkCopyMemoryToImageIndirectCommandNV calloc(MemoryStack stack) {
        return new VkCopyMemoryToImageIndirectCommandNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nsrcAddress(long struct) {
        return UNSAFE.getLong(null, struct + (long)SRCADDRESS);
    }

    public static int nbufferRowLength(long struct) {
        return UNSAFE.getInt(null, struct + (long)BUFFERROWLENGTH);
    }

    public static int nbufferImageHeight(long struct) {
        return UNSAFE.getInt(null, struct + (long)BUFFERIMAGEHEIGHT);
    }

    public static VkImageSubresourceLayers nimageSubresource(long struct) {
        return VkImageSubresourceLayers.create(struct + (long)IMAGESUBRESOURCE);
    }

    public static VkOffset3D nimageOffset(long struct) {
        return VkOffset3D.create(struct + (long)IMAGEOFFSET);
    }

    public static VkExtent3D nimageExtent(long struct) {
        return VkExtent3D.create(struct + (long)IMAGEEXTENT);
    }

    public static void nsrcAddress(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SRCADDRESS, value);
    }

    public static void nbufferRowLength(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BUFFERROWLENGTH, value);
    }

    public static void nbufferImageHeight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BUFFERIMAGEHEIGHT, value);
    }

    public static void nimageSubresource(long struct, VkImageSubresourceLayers value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)IMAGESUBRESOURCE), (long)VkImageSubresourceLayers.SIZEOF);
    }

    public static void nimageOffset(long struct, VkOffset3D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)IMAGEOFFSET), (long)VkOffset3D.SIZEOF);
    }

    public static void nimageExtent(long struct, VkExtent3D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)IMAGEEXTENT), (long)VkExtent3D.SIZEOF);
    }

    static {
        Struct.Layout layout = VkCopyMemoryToImageIndirectCommandNV.__struct((Struct.Member[])new Struct.Member[]{VkCopyMemoryToImageIndirectCommandNV.__member((int)8), VkCopyMemoryToImageIndirectCommandNV.__member((int)4), VkCopyMemoryToImageIndirectCommandNV.__member((int)4), VkCopyMemoryToImageIndirectCommandNV.__member((int)VkImageSubresourceLayers.SIZEOF, (int)VkImageSubresourceLayers.ALIGNOF), VkCopyMemoryToImageIndirectCommandNV.__member((int)VkOffset3D.SIZEOF, (int)VkOffset3D.ALIGNOF), VkCopyMemoryToImageIndirectCommandNV.__member((int)VkExtent3D.SIZEOF, (int)VkExtent3D.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SRCADDRESS = layout.offsetof(0);
        BUFFERROWLENGTH = layout.offsetof(1);
        BUFFERIMAGEHEIGHT = layout.offsetof(2);
        IMAGESUBRESOURCE = layout.offsetof(3);
        IMAGEOFFSET = layout.offsetof(4);
        IMAGEEXTENT = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkCopyMemoryToImageIndirectCommandNV, Buffer>
    implements NativeResource {
        private static final VkCopyMemoryToImageIndirectCommandNV ELEMENT_FACTORY = VkCopyMemoryToImageIndirectCommandNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkCopyMemoryToImageIndirectCommandNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceAddress")
        public long srcAddress() {
            return VkCopyMemoryToImageIndirectCommandNV.nsrcAddress(this.address());
        }

        @NativeType(value="uint32_t")
        public int bufferRowLength() {
            return VkCopyMemoryToImageIndirectCommandNV.nbufferRowLength(this.address());
        }

        @NativeType(value="uint32_t")
        public int bufferImageHeight() {
            return VkCopyMemoryToImageIndirectCommandNV.nbufferImageHeight(this.address());
        }

        public VkImageSubresourceLayers imageSubresource() {
            return VkCopyMemoryToImageIndirectCommandNV.nimageSubresource(this.address());
        }

        public VkOffset3D imageOffset() {
            return VkCopyMemoryToImageIndirectCommandNV.nimageOffset(this.address());
        }

        public VkExtent3D imageExtent() {
            return VkCopyMemoryToImageIndirectCommandNV.nimageExtent(this.address());
        }

        public Buffer srcAddress(@NativeType(value="VkDeviceAddress") long value) {
            VkCopyMemoryToImageIndirectCommandNV.nsrcAddress(this.address(), value);
            return this;
        }

        public Buffer bufferRowLength(@NativeType(value="uint32_t") int value) {
            VkCopyMemoryToImageIndirectCommandNV.nbufferRowLength(this.address(), value);
            return this;
        }

        public Buffer bufferImageHeight(@NativeType(value="uint32_t") int value) {
            VkCopyMemoryToImageIndirectCommandNV.nbufferImageHeight(this.address(), value);
            return this;
        }

        public Buffer imageSubresource(VkImageSubresourceLayers value) {
            VkCopyMemoryToImageIndirectCommandNV.nimageSubresource(this.address(), value);
            return this;
        }

        public Buffer imageSubresource(Consumer<VkImageSubresourceLayers> consumer) {
            consumer.accept(this.imageSubresource());
            return this;
        }

        public Buffer imageOffset(VkOffset3D value) {
            VkCopyMemoryToImageIndirectCommandNV.nimageOffset(this.address(), value);
            return this;
        }

        public Buffer imageOffset(Consumer<VkOffset3D> consumer) {
            consumer.accept(this.imageOffset());
            return this;
        }

        public Buffer imageExtent(VkExtent3D value) {
            VkCopyMemoryToImageIndirectCommandNV.nimageExtent(this.address(), value);
            return this;
        }

        public Buffer imageExtent(Consumer<VkExtent3D> consumer) {
            consumer.accept(this.imageExtent());
            return this;
        }
    }
}

