/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkBufferCopy2;

public class VkCopyBufferInfo2
extends Struct<VkCopyBufferInfo2>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SRCBUFFER;
    public static final int DSTBUFFER;
    public static final int REGIONCOUNT;
    public static final int PREGIONS;

    protected VkCopyBufferInfo2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkCopyBufferInfo2 create(long address, @Nullable ByteBuffer container) {
        return new VkCopyBufferInfo2(address, container);
    }

    public VkCopyBufferInfo2(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkCopyBufferInfo2.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCopyBufferInfo2.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCopyBufferInfo2.npNext(this.address());
    }

    @NativeType(value="VkBuffer")
    public long srcBuffer() {
        return VkCopyBufferInfo2.nsrcBuffer(this.address());
    }

    @NativeType(value="VkBuffer")
    public long dstBuffer() {
        return VkCopyBufferInfo2.ndstBuffer(this.address());
    }

    @NativeType(value="uint32_t")
    public int regionCount() {
        return VkCopyBufferInfo2.nregionCount(this.address());
    }

    @NativeType(value="VkBufferCopy2 const *")
    public VkBufferCopy2.Buffer pRegions() {
        return VkCopyBufferInfo2.npRegions(this.address());
    }

    public VkCopyBufferInfo2 sType(@NativeType(value="VkStructureType") int value) {
        VkCopyBufferInfo2.nsType(this.address(), value);
        return this;
    }

    public VkCopyBufferInfo2 sType$Default() {
        return this.sType(1000337000);
    }

    public VkCopyBufferInfo2 pNext(@NativeType(value="void const *") long value) {
        VkCopyBufferInfo2.npNext(this.address(), value);
        return this;
    }

    public VkCopyBufferInfo2 srcBuffer(@NativeType(value="VkBuffer") long value) {
        VkCopyBufferInfo2.nsrcBuffer(this.address(), value);
        return this;
    }

    public VkCopyBufferInfo2 dstBuffer(@NativeType(value="VkBuffer") long value) {
        VkCopyBufferInfo2.ndstBuffer(this.address(), value);
        return this;
    }

    public VkCopyBufferInfo2 pRegions(@NativeType(value="VkBufferCopy2 const *") VkBufferCopy2.Buffer value) {
        VkCopyBufferInfo2.npRegions(this.address(), value);
        return this;
    }

    public VkCopyBufferInfo2 set(int sType, long pNext, long srcBuffer, long dstBuffer, VkBufferCopy2.Buffer pRegions) {
        this.sType(sType);
        this.pNext(pNext);
        this.srcBuffer(srcBuffer);
        this.dstBuffer(dstBuffer);
        this.pRegions(pRegions);
        return this;
    }

    public VkCopyBufferInfo2 set(VkCopyBufferInfo2 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkCopyBufferInfo2 malloc() {
        return new VkCopyBufferInfo2(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkCopyBufferInfo2 calloc() {
        return new VkCopyBufferInfo2(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkCopyBufferInfo2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkCopyBufferInfo2(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkCopyBufferInfo2 create(long address) {
        return new VkCopyBufferInfo2(address, null);
    }

    @Nullable
    public static VkCopyBufferInfo2 createSafe(long address) {
        return address == 0L ? null : new VkCopyBufferInfo2(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkCopyBufferInfo2.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCopyBufferInfo2.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkCopyBufferInfo2 malloc(MemoryStack stack) {
        return new VkCopyBufferInfo2(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkCopyBufferInfo2 calloc(MemoryStack stack) {
        return new VkCopyBufferInfo2(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nsrcBuffer(long struct) {
        return UNSAFE.getLong(null, struct + (long)SRCBUFFER);
    }

    public static long ndstBuffer(long struct) {
        return UNSAFE.getLong(null, struct + (long)DSTBUFFER);
    }

    public static int nregionCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)REGIONCOUNT);
    }

    public static VkBufferCopy2.Buffer npRegions(long struct) {
        return VkBufferCopy2.create(MemoryUtil.memGetAddress((long)(struct + (long)PREGIONS)), VkCopyBufferInfo2.nregionCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nsrcBuffer(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SRCBUFFER, value);
    }

    public static void ndstBuffer(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)DSTBUFFER, value);
    }

    public static void nregionCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)REGIONCOUNT, value);
    }

    public static void npRegions(long struct, VkBufferCopy2.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PREGIONS), (long)value.address());
        VkCopyBufferInfo2.nregionCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PREGIONS)));
    }

    static {
        Struct.Layout layout = VkCopyBufferInfo2.__struct((Struct.Member[])new Struct.Member[]{VkCopyBufferInfo2.__member((int)4), VkCopyBufferInfo2.__member((int)POINTER_SIZE), VkCopyBufferInfo2.__member((int)8), VkCopyBufferInfo2.__member((int)8), VkCopyBufferInfo2.__member((int)4), VkCopyBufferInfo2.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SRCBUFFER = layout.offsetof(2);
        DSTBUFFER = layout.offsetof(3);
        REGIONCOUNT = layout.offsetof(4);
        PREGIONS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkCopyBufferInfo2, Buffer>
    implements NativeResource {
        private static final VkCopyBufferInfo2 ELEMENT_FACTORY = VkCopyBufferInfo2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkCopyBufferInfo2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCopyBufferInfo2.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCopyBufferInfo2.npNext(this.address());
        }

        @NativeType(value="VkBuffer")
        public long srcBuffer() {
            return VkCopyBufferInfo2.nsrcBuffer(this.address());
        }

        @NativeType(value="VkBuffer")
        public long dstBuffer() {
            return VkCopyBufferInfo2.ndstBuffer(this.address());
        }

        @NativeType(value="uint32_t")
        public int regionCount() {
            return VkCopyBufferInfo2.nregionCount(this.address());
        }

        @NativeType(value="VkBufferCopy2 const *")
        public VkBufferCopy2.Buffer pRegions() {
            return VkCopyBufferInfo2.npRegions(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCopyBufferInfo2.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000337000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCopyBufferInfo2.npNext(this.address(), value);
            return this;
        }

        public Buffer srcBuffer(@NativeType(value="VkBuffer") long value) {
            VkCopyBufferInfo2.nsrcBuffer(this.address(), value);
            return this;
        }

        public Buffer dstBuffer(@NativeType(value="VkBuffer") long value) {
            VkCopyBufferInfo2.ndstBuffer(this.address(), value);
            return this;
        }

        public Buffer pRegions(@NativeType(value="VkBufferCopy2 const *") VkBufferCopy2.Buffer value) {
            VkCopyBufferInfo2.npRegions(this.address(), value);
            return this;
        }
    }
}

