/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.backend;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jolokia.backend.MBeanServerHandlerMBean;
import org.jolokia.detector.AbstractServerDetector;
import org.jolokia.detector.ServerDetector;
import org.jolokia.detector.ServerHandle;
import org.jolokia.handler.JsonRequestHandler;
import org.jolokia.request.JmxRequest;
import org.jolokia.util.ConfigKey;
import org.jolokia.util.LogHandler;
import org.jolokia.util.ServiceObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanServerHandler
implements MBeanServerHandlerMBean,
MBeanRegistration {
    private Set<MBeanServer> mBeanServers;
    private Set<MBeanServerConnection> mBeanServerConnections;
    private String qualifier;
    private ServerHandle serverHandle;
    private List<MBeanHandle> mBeanHandles = new ArrayList<MBeanHandle>();

    public void initMBean() throws MalformedObjectNameException, NotCompliantMBeanException {
        try {
            this.registerMBean(this, this.getObjectName());
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            // empty catch block
        }
    }

    public MBeanServerHandler(Map<ConfigKey, String> pConfig, LogHandler pLogHandler) {
        List<ServerDetector> detectors = this.lookupDetectors();
        this.initMBeanServers(detectors);
        this.serverHandle = this.detectServers(detectors, pLogHandler);
        if (this.serverHandle != null) {
            this.serverHandle.postDetect(this.mBeanServers, pConfig, pLogHandler);
        }
        this.qualifier = pConfig.get((Object)ConfigKey.MBEAN_QUALIFIER);
    }

    public Object dispatchRequest(JsonRequestHandler pRequestHandler, JmxRequest pJmxReq) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException {
        this.serverHandle.preDispatch(this.mBeanServers, pJmxReq);
        if (pRequestHandler.handleAllServersAtOnce(pJmxReq)) {
            try {
                return pRequestHandler.handleRequest(this.mBeanServerConnections, pJmxReq);
            }
            catch (IOException e) {
                throw new IllegalStateException("Internal: IOException " + e + ". Shouldn't happen.", e);
            }
        }
        return this.handleRequest(pRequestHandler, pJmxReq);
    }

    private Object handleRequest(JsonRequestHandler pRequestHandler, JmxRequest pJmxReq) throws ReflectionException, MBeanException, AttributeNotFoundException, InstanceNotFoundException {
        AttributeNotFoundException attrException = null;
        InstanceNotFoundException objNotFoundException = null;
        for (MBeanServer s : this.mBeanServers) {
            try {
                return pRequestHandler.handleRequest(s, pJmxReq);
            }
            catch (InstanceNotFoundException exp) {
                objNotFoundException = exp;
            }
            catch (AttributeNotFoundException exp) {
                attrException = exp;
            }
            catch (IOException exp) {
                throw new IllegalStateException("I/O Error while dispatching", exp);
            }
        }
        if (attrException != null) {
            throw attrException;
        }
        throw objNotFoundException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName registerMBean(Object pMBean, String ... pOptionalName) throws MalformedObjectNameException, NotCompliantMBeanException, InstanceAlreadyExistsException {
        if (this.mBeanServers.size() > 0) {
            List<MBeanHandle> list = this.mBeanHandles;
            synchronized (list) {
                Exception lastExp = null;
                for (MBeanServer server : this.mBeanServers) {
                    try {
                        String name = pOptionalName != null && pOptionalName.length > 0 ? pOptionalName[0] : null;
                        ObjectName registeredName = this.serverHandle.registerMBeanAtServer(server, pMBean, name);
                        this.mBeanHandles.add(new MBeanHandle(server, registeredName));
                        return registeredName;
                    }
                    catch (RuntimeException exp) {
                        lastExp = exp;
                    }
                    catch (MBeanRegistrationException exp) {
                        lastExp = exp;
                    }
                }
                if (lastExp != null) {
                    throw new IllegalStateException("Could not register " + pMBean + ": " + lastExp, lastExp);
                }
            }
        }
        throw new IllegalStateException("No MBeanServer initialized yet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMBeans() throws JMException {
        List<MBeanHandle> list = this.mBeanHandles;
        synchronized (list) {
            ArrayList<JMException> exceptions = new ArrayList<JMException>();
            ArrayList<MBeanHandle> unregistered = new ArrayList<MBeanHandle>();
            for (MBeanHandle handle : this.mBeanHandles) {
                try {
                    handle.server.unregisterMBean(handle.objectName);
                    unregistered.add(handle);
                }
                catch (InstanceNotFoundException e) {
                    exceptions.add(e);
                }
                catch (MBeanRegistrationException e) {
                    exceptions.add(e);
                }
            }
            this.mBeanHandles.removeAll(unregistered);
            if (exceptions.size() == 1) {
                throw (JMException)exceptions.get(0);
            }
            if (exceptions.size() > 1) {
                StringBuilder ret = new StringBuilder();
                for (JMException e : exceptions) {
                    ret.append(e.getMessage()).append(", ");
                }
                throw new JMException(ret.substring(0, ret.length() - 2));
            }
        }
    }

    public Set<MBeanServer> getMBeanServers() {
        return Collections.unmodifiableSet(this.mBeanServers);
    }

    public ServerHandle getServerHandle() {
        return this.serverHandle;
    }

    private List<ServerDetector> lookupDetectors() {
        List<ServerDetector> detectors = ServiceObjectFactory.createServiceObjects("META-INF/detectors-default", "META-INF/detectors");
        detectors.add(new FallbackServerDetector());
        return detectors;
    }

    private void initMBeanServers(List<ServerDetector> pDetectors) {
        this.mBeanServers = new LinkedHashSet<MBeanServer>();
        for (ServerDetector detector : pDetectors) {
            detector.addMBeanServers(this.mBeanServers);
        }
        ArrayList<MBeanServer> beanServers = MBeanServerFactory.findMBeanServer(null);
        if (beanServers != null) {
            this.mBeanServers.addAll(beanServers);
        }
        this.mBeanServers.add(ManagementFactory.getPlatformMBeanServer());
        this.mBeanServerConnections = new LinkedHashSet<MBeanServerConnection>();
        for (MBeanServer server : this.mBeanServers) {
            this.mBeanServerConnections.add(server);
        }
    }

    private ServerHandle detectServers(List<ServerDetector> pDetectors, LogHandler pLogHandler) {
        for (ServerDetector detector : pDetectors) {
            try {
                ServerHandle info = detector.detect(this.mBeanServers);
                if (info == null) continue;
                return info;
            }
            catch (Exception exp) {
                pLogHandler.error("Error while using detector " + detector.getClass().getSimpleName() + ": " + exp, exp);
            }
        }
        return null;
    }

    @Override
    public String mBeanServersInfo() {
        StringBuffer ret = new StringBuffer();
        Set<MBeanServer> servers = this.getMBeanServers();
        ret.append("Found ").append(servers.size()).append(" MBeanServers\n");
        for (MBeanServer s : servers) {
            ret.append("    ").append("++ ").append(s.toString()).append(": default domain = ").append(s.getDefaultDomain()).append(", ").append(s.getMBeanCount()).append(" MBeans\n");
            ret.append("        Domains:\n");
            boolean javaLangFound = false;
            for (String d : s.getDomains()) {
                if ("java.lang".equals(d)) {
                    javaLangFound = true;
                }
                this.appendDomainInfo(ret, s, d);
            }
            if (javaLangFound) continue;
            this.appendDomainInfo(ret, s, "java.lang");
        }
        ret.append("\n");
        ret.append("Platform MBeanServer: ").append(ManagementFactory.getPlatformMBeanServer()).append("\n");
        return ret.toString();
    }

    private void appendDomainInfo(StringBuffer pRet, MBeanServer pServer, String pDomain) {
        try {
            pRet.append("         == ").append(pDomain).append("\n");
            Set<ObjectInstance> beans = pServer.queryMBeans(new ObjectName(pDomain + ":*"), null);
            for (ObjectInstance o : beans) {
                String n = o.getObjectName().getCanonicalKeyPropertyListString();
                pRet.append("              ").append(n).append("\n");
            }
        }
        catch (MalformedObjectNameException e) {
            pRet.append("              INTERNAL ERROR: ").append(e).append("\n");
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return new ObjectName(this.getObjectName());
    }

    public String getObjectName() {
        return "jolokia:type=ServerHandler" + (this.qualifier != null ? "," + this.qualifier : "");
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() {
    }

    @Override
    public void postDeregister() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FallbackServerDetector
    extends AbstractServerDetector {
        private FallbackServerDetector() {
        }

        @Override
        public ServerHandle detect(Set<MBeanServer> pMbeanServers) {
            return new ServerHandle(null, null, null, null, null);
        }
    }

    private static final class MBeanHandle {
        private ObjectName objectName;
        private MBeanServer server;

        private MBeanHandle(MBeanServer pServer, ObjectName pRegisteredName) {
            this.server = pServer;
            this.objectName = pRegisteredName;
        }
    }
}

