/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.SourceLocationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.wasm.resolve.diagnostics.ErrorsWasm;
import org.jetbrains.kotlin.wasm.resolve.diagnostics.WasmImportAnnotationChecker;
import org.jetbrains.kotlin.wasm.util.JsCodeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/wasm/resolve/diagnostics/WasmExportAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "checkJsInterop", "", "<init>", "(Z)V", "getCheckJsInterop", "()Z", "wasmExportFqName", "Lorg/jetbrains/kotlin/name/FqName;", "jsExportFqName", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "wasm.frontend"})
public abstract class WasmExportAnnotationChecker
implements DeclarationChecker {
    private final boolean checkJsInterop;
    @NotNull
    private final FqName wasmExportFqName;
    @NotNull
    private final FqName jsExportFqName;

    public WasmExportAnnotationChecker(boolean checkJsInterop) {
        this.checkJsInterop = checkJsInterop;
        this.wasmExportFqName = new FqName("kotlin.wasm.WasmExport");
        this.jsExportFqName = new FqName("kotlin.js.JsExport");
    }

    public final boolean getCheckJsInterop() {
        return this.checkJsInterop;
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(descriptor instanceof FunctionDescriptor)) {
            return;
        }
        AnnotationDescriptor annotationDescriptor = descriptor.getAnnotations().findAnnotation(this.wasmExportFqName);
        if (annotationDescriptor == null) {
            return;
        }
        AnnotationDescriptor wasmExport = annotationDescriptor;
        PsiElement psiElement = PsiSourceElementKt.getPsi(wasmExport.getSource());
        if (psiElement == null) {
            psiElement = declaration;
        }
        PsiElement wasmExportPsi = psiElement;
        BindingTrace trace = context.getTrace();
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        BindingContext bindingContext2 = bindingContext;
        if (this.checkJsInterop && descriptor.getAnnotations().hasAnnotation(this.jsExportFqName)) {
            PsiElement psiElement2 = SourceLocationUtilsKt.findPsi(descriptor);
            if (psiElement2 == null) {
                psiElement2 = declaration;
            }
            PsiElement reportOn = psiElement2;
            trace.report(ErrorsWasm.JS_AND_WASM_EXPORTS_ON_SAME_DECLARATION.on(reportOn));
        }
        if (DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)descriptor) || this.checkJsInterop && JsCodeUtilsKt.hasValidJsCodeBody((FunctionDescriptor)descriptor, bindingContext2)) {
            trace.report(ErrorsWasm.WASM_EXPORT_ON_EXTERNAL_DECLARATION.on(wasmExportPsi));
        }
        if (!DescriptorUtils.isTopLevelDeclaration(descriptor)) {
            trace.report(ErrorsWasm.NESTED_WASM_EXPORT.on(wasmExportPsi));
        }
        WasmImportAnnotationChecker.INSTANCE.checkSignatureIsPrimitive((FunctionDescriptor)descriptor, trace, declaration);
    }
}

