/*
 * Decompiled with CFR 0.152.
 */
package jenkins.maven3.agent;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import jenkins.maven3.agent.RealFilterOutputStream;
import org.codehaus.plexus.classworlds.launcher.Launcher;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;

public class Maven31Main {
    private static Launcher launcher;

    public static void main(String ... args) throws Exception {
        Maven31Main.main(new File(args[0]), new File(args[1]), new File(args[2]), new File(args[3]), Integer.parseInt(args[4]));
    }

    public static void main(File m2Home, File remotingJar, File interceptorJar, File interceptorCommonJar, int tcpPort) throws Exception {
        Socket s;
        try {
            m2Home = m2Home.getCanonicalFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (!m2Home.exists()) {
            System.err.println("No such directory exists: " + m2Home);
            System.exit(1);
        }
        Maven31Main.versionCheck();
        System.setProperty("maven.home", m2Home.getPath());
        System.setProperty("maven3.interceptor.common", (interceptorCommonJar != null ? interceptorCommonJar : interceptorCommonJar).getPath());
        System.setProperty("maven3.interceptor", (interceptorJar != null ? interceptorJar : interceptorJar).getPath());
        launcher = new Launcher();
        launcher.setSystemClassLoader(Maven31Main.class.getClassLoader());
        launcher.configure(Maven31Main.getClassWorldsConfStream());
        ClassRealm remoting = launcher.getWorld().newRealm("hudson-remoting", launcher.getSystemClassLoader());
        remoting.setParentRealm(launcher.getWorld().getRealm("plexus.core"));
        remoting.addURL(remotingJar.toURI().toURL());
        String mavenRemoteUseInetEnvVar = System.getenv("MAVEN_REMOTE_USEINET");
        boolean mavenRemoteUseInet = Boolean.parseBoolean(mavenRemoteUseInetEnvVar);
        if (mavenRemoteUseInet) {
            InetAddress host = InetAddress.getLocalHost();
            String hostname = host.getHostName();
            System.out.println("use inet address " + hostname);
            s = new Socket(hostname, tcpPort);
        } else {
            s = new Socket((String)null, tcpPort);
        }
        Class remotingLauncher = remoting.loadClass("hudson.remoting.Launcher");
        remotingLauncher.getMethod("main", InputStream.class, OutputStream.class).invoke(null, new BufferedInputStream(new FilterInputStream(s.getInputStream()){

            public void close() throws IOException {
                s.shutdownInput();
            }
        }), new BufferedOutputStream(new RealFilterOutputStream(s.getOutputStream()){

            public void close() throws IOException {
                s.shutdownOutput();
            }
        }));
        System.exit(0);
    }

    public static void addPlexusComponents(URL[] modules) {
        try {
            ClassRealm realm = launcher.getWorld().getRealm("plexus.core");
            for (int i = 0; i < modules.length; ++i) {
                realm.addURL(modules[i]);
            }
        }
        catch (NoSuchRealmException e) {
            throw new Error(e);
        }
    }

    public static int launch(String[] args) throws Exception {
        try {
            launcher.launch(args);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        return launcher.getExitCode();
    }

    private static InputStream getClassWorldsConfStream() throws FileNotFoundException {
        String classWorldsConfLocation = System.getProperty("classworlds.conf");
        if (!(classWorldsConfLocation != null && classWorldsConfLocation.trim().length() != 0 || (classWorldsConfLocation = System.getenv("classworlds.conf")) != null && classWorldsConfLocation.trim().length() != 0)) {
            return Maven31Main.class.getResourceAsStream("classworlds.conf");
        }
        return new FileInputStream(new File(classWorldsConfLocation));
    }

    private static void versionCheck() {
        String v = System.getProperty("java.class.version");
        if (v != null) {
            try {
                if ((double)Float.parseFloat(v) < 49.0) {
                    System.err.println("Native maven support requires Java 1.5 or later, but this Maven is using " + System.getProperty("java.home"));
                    System.err.println("Please use the freestyle project.");
                    System.exit(1);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

